/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.concatenation.Jdk5StringConcatenationPredicate;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ReplaceConcatenationWithFormatStringIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new Jdk5StringConcatenationPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)element;
        PsiElement parent = expression2.getParent();
        while (ExpressionUtils.isConcatenation(parent)) {
            expression2 = (PsiPolyadicExpression)parent;
            parent = expression2.getParent();
        }
        StringBuilder formatString = new StringBuilder();
        ArrayList<PsiExpression> formatParameters = new ArrayList<PsiExpression>();
        PsiConcatenationUtil.buildFormatString((PsiExpression)expression2, (StringBuilder)formatString, formatParameters, (boolean)true);
        if (ReplaceConcatenationWithFormatStringIntention.replaceWithPrintfExpression((PsiExpression)expression2, formatString, formatParameters)) {
            return;
        }
        StringBuilder newExpression = new StringBuilder();
        newExpression.append("java.lang.String.format(\"");
        newExpression.append((CharSequence)formatString);
        newExpression.append('\"');
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(", ");
            newExpression.append(formatParameter.getText());
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)expression2, newExpression.toString());
    }

    private static boolean replaceWithPrintfExpression(PsiExpression expression2, CharSequence formatString, List<PsiExpression> formatParameters) throws IncorrectOperationException {
        boolean insertNewline;
        PsiElement expressionParent = expression2.getParent();
        if (!(expressionParent instanceof PsiExpressionList)) {
            return false;
        }
        PsiElement grandParent = expressionParent.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String name = methodExpression.getReferenceName();
        if ("println".equals(name)) {
            insertNewline = true;
        } else if ("print".equals(name)) {
            insertNewline = false;
        } else {
            return false;
        }
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (!"java.io.PrintStream".equals(qualifiedName) && !"java.io.Printwriter".equals(qualifiedName)) {
            return false;
        }
        StringBuilder newExpression = new StringBuilder();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier != null) {
            newExpression.append(qualifier.getText());
            newExpression.append('.');
        }
        newExpression.append("printf(\"");
        newExpression.append(formatString);
        if (insertNewline) {
            newExpression.append("%n");
        }
        newExpression.append('\"');
        for (PsiExpression formatParameter : formatParameters) {
            newExpression.append(", ");
            newExpression.append(formatParameter.getText());
        }
        newExpression.append(')');
        PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression.toString());
        return true;
    }
}

