/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.FlipConditionalPredicate;
import org.jetbrains.annotations.NotNull;

public class FlipConditionalIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new FlipConditionalPredicate();
    }

    @Override
    public void processIntention(PsiElement element) {
        PsiConditionalExpression exp = (PsiConditionalExpression)element;
        PsiExpression condition2 = exp.getCondition();
        PsiExpression elseExpression2 = exp.getElseExpression();
        PsiExpression thenExpression2 = exp.getThenExpression();
        assert (elseExpression2 != null);
        assert (thenExpression2 != null);
        String newExpression = BoolUtils.getNegatedExpressionText(condition2) + '?' + elseExpression2.getText() + ':' + thenExpression2.getText();
        PsiReplacementUtil.replaceExpression((PsiExpression)exp, newExpression);
    }
}

