/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceConditionalWithBooleanExpressionIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (!(element instanceof PsiConditionalExpression)) {
                    return false;
                }
                PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
                PsiType type2 = conditionalExpression.getType();
                return PsiType.BOOLEAN.equals((Object)type2) || type2 != null && type2.equalsToText("java.lang.Boolean");
            }
        };
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
        PsiExpression condition2 = conditionalExpression.getCondition();
        String replacementText = condition2.getText() + "&&" + ReplaceConditionalWithBooleanExpressionIntention.getText(conditionalExpression.getThenExpression()) + "||" + BoolUtils.getNegatedExpressionText(condition2, 13) + "&&" + ReplaceConditionalWithBooleanExpressionIntention.getText(conditionalExpression.getElseExpression());
        PsiReplacementUtil.replaceExpression((PsiExpression)element, replacementText);
    }

    private static String getText(PsiExpression expression2) {
        if (ParenthesesUtils.getPrecedence(expression2) > 13) {
            return '(' + expression2.getText() + ')';
        }
        return expression2.getText();
    }
}

