/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.conditional;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.conditional.ReplaceConditionalWithIfPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConditionalWithIfIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceConditionalWithIfIntention.class.getName()));

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new ReplaceConditionalWithIfPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiConditionalExpression expression2 = (PsiConditionalExpression)element;
        ReplaceConditionalWithIfIntention.replaceConditionalWithIf(expression2);
    }

    private static void replaceConditionalWithIf(PsiConditionalExpression expression2) {
        PsiStatement statement2;
        PsiElement expressionParent = expression2.getParent();
        if (expressionParent instanceof PsiLambdaExpression) {
            PsiElement codeBlock = ((PsiLambdaExpression)RefactoringUtil.expandExpressionLambdaToCodeBlock((PsiElement)expression2)).getBody();
            LOG.assertTrue(codeBlock instanceof PsiCodeBlock, (Object)codeBlock);
            PsiStatement statement3 = ((PsiCodeBlock)codeBlock).getStatements()[0];
            expression2 = (PsiConditionalExpression)(statement3 instanceof PsiReturnStatement ? ((PsiReturnStatement)statement3).getReturnValue() : ((PsiExpressionStatement)statement3).getExpression());
        }
        if ((statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiStatement.class)) == null) {
            return;
        }
        PsiVariable variable = statement2 instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiVariable.class) : null;
        PsiExpression thenExpression2 = ParenthesesUtils.stripParentheses(expression2.getThenExpression());
        PsiExpression elseExpression2 = ParenthesesUtils.stripParentheses(expression2.getElseExpression());
        PsiExpression condition2 = ParenthesesUtils.stripParentheses(expression2.getCondition());
        StringBuilder newStatement = new StringBuilder();
        newStatement.append("if(");
        if (condition2 != null) {
            newStatement.append(condition2.getText());
        }
        newStatement.append(')');
        if (variable != null) {
            int conditionIdx;
            String name = variable.getName();
            newStatement.append(name).append('=');
            PsiExpression initializer = variable.getInitializer();
            if (initializer == null) {
                return;
            }
            if (initializer instanceof PsiArrayInitializerExpression && (conditionIdx = ArrayUtilRt.find((Object[])((PsiArrayInitializerExpression)initializer).getInitializers(), (Object)expression2)) >= 0) {
                PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)(initializer = (PsiExpression)initializer.replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, variable.getType())))).getArrayInitializer();
                LOG.assertTrue(arrayInitializer != null, (Object)initializer.getText());
                expression2 = (PsiConditionalExpression)arrayInitializer.getInitializers()[conditionIdx];
                thenExpression2 = expression2.getThenExpression();
                elseExpression2 = expression2.getElseExpression();
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression2, thenExpression2, newStatement);
            newStatement.append("; else ").append(name).append('=');
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)initializer, (PsiExpression)expression2, elseExpression2, newStatement);
            newStatement.append(';');
            initializer.delete();
            PsiManager manager = statement2.getManager();
            Project project2 = manager.getProject();
            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
            PsiElementFactory factory = facade.getElementFactory();
            PsiStatement ifStatement = factory.createStatementFromText(newStatement.toString(), (PsiElement)statement2);
            PsiElement parent = statement2.getParent();
            PsiElement addedElement = parent.addAfter((PsiElement)ifStatement, (PsiElement)statement2);
            CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            styleManager.reformat(addedElement);
        } else {
            boolean addBraces;
            boolean bl = addBraces = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null;
            if (addBraces || thenExpression2 == null) {
                newStatement.append('{');
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement2, (PsiExpression)expression2, thenExpression2, newStatement);
            if (addBraces) {
                newStatement.append("} else {");
            } else {
                if (thenExpression2 == null) {
                    newStatement.append('}');
                }
                newStatement.append(" else ");
                if (elseExpression2 == null) {
                    newStatement.append('{');
                }
            }
            ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses((PsiElement)statement2, (PsiExpression)expression2, elseExpression2, newStatement);
            if (addBraces || elseExpression2 == null) {
                newStatement.append('}');
            }
            PsiReplacementUtil.replaceStatement(statement2, newStatement.toString());
        }
    }

    private static void appendElementTextWithoutParentheses(@NotNull PsiElement element, @NotNull PsiExpression expressionToReplace, @Nullable PsiExpression replacementExpression, @NotNull StringBuilder out) {
        PsiElement expressionParent = expressionToReplace.getParent();
        if (expressionParent instanceof PsiParenthesizedExpression) {
            PsiElement grandParent = expressionParent.getParent();
            if (replacementExpression == null || !(grandParent instanceof PsiExpression) || !ParenthesesUtils.areParenthesesNeeded(replacementExpression, (PsiExpression)grandParent, false)) {
                ReplaceConditionalWithIfIntention.appendElementTextWithoutParentheses(element, (PsiExpression)expressionParent, replacementExpression, out);
                return;
            }
        }
        boolean needsCast = replacementExpression != null && MethodCallUtils.isNecessaryForSurroundingMethodCall(expressionToReplace, replacementExpression);
        ReplaceConditionalWithIfIntention.appendElementText(element, expressionToReplace, replacementExpression, needsCast, out);
    }

    private static void appendElementText(@NotNull PsiElement element, @NotNull PsiExpression elementToReplace, @Nullable PsiExpression replacementExpression, boolean insertCast, @NotNull StringBuilder out) {
        if (element.equals(elementToReplace)) {
            String replacementText = replacementExpression == null ? "" : replacementExpression.getText();
            PsiType type2 = GenericsUtil.getVariableTypeByExpressionType((PsiType)ExpectedTypeUtils.findExpectedType(elementToReplace, true));
            if (insertCast && type2 != null) {
                out.append('(').append(type2.getCanonicalText()).append(')');
            }
            out.append(replacementText);
            return;
        }
        PsiElement[] children2 = element.getChildren();
        if (children2.length == 0) {
            PsiComment comment;
            IElementType tokenType;
            out.append(element.getText());
            if (element instanceof PsiComment && (tokenType = (comment = (PsiComment)element).getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
                out.append('\n');
            }
            return;
        }
        for (PsiElement child : children2) {
            ReplaceConditionalWithIfIntention.appendElementText(child, elementToReplace, replacementExpression, insertCast, out);
        }
    }
}

