/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.constant;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.constant.ConstantSubexpressionPredicate;
import com.siyeh.ipp.psiutils.HighlightUtil;
import org.jetbrains.annotations.NotNull;

public class ConstantSubexpressionIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConstantSubexpressionPredicate();
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        PsiJavaToken token;
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                throw new AssertionError();
            }
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        String text = HighlightUtil.getPresentableText((PsiElement)subexpression);
        return IntentionPowerPackBundle.message("constant.expression.intention.name", text);
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token;
        if (element instanceof PsiJavaToken) {
            token = (PsiJavaToken)element;
        } else {
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling instanceof PsiJavaToken) {
                token = (PsiJavaToken)prevSibling;
            } else {
                throw new AssertionError();
            }
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)element.getParent();
        PsiPolyadicExpression subexpression = ConstantSubexpressionPredicate.getSubexpression(polyadicExpression, token);
        if (subexpression == null) {
            return;
        }
        Object value2 = ExpressionUtils.computeConstantExpression((PsiExpression)subexpression);
        StringBuilder newExpressionText = new StringBuilder();
        PsiExpression[] operands2 = polyadicExpression.getOperands();
        PsiExpression prevOperand = null;
        PsiJavaToken prevToken = null;
        for (PsiExpression operand2 : operands2) {
            PsiJavaToken currentToken = polyadicExpression.getTokenBeforeOperand(operand2);
            if (token == currentToken) {
                if (prevToken != null) {
                    newExpressionText.append(prevToken.getText());
                }
                if (newExpressionText.length() > 0) {
                    newExpressionText.append(' ');
                }
                if (value2 instanceof Long) {
                    newExpressionText.append(value2).append('L');
                } else if (value2 instanceof Double) {
                    double v = (Double)value2;
                    if (Double.isNaN(v)) {
                        newExpressionText.append("java.lang.Double.NaN");
                    } else if (Double.isInfinite(v)) {
                        if (v > 0.0) {
                            newExpressionText.append("java.lang.Double.POSITIVE_INFINITY");
                        } else {
                            newExpressionText.append("java.lang.Double.NEGATIVE_INFINITY");
                        }
                    } else {
                        newExpressionText.append(Double.toString(v));
                    }
                } else if (value2 instanceof Float) {
                    float v = ((Float)value2).floatValue();
                    if (Float.isNaN(v)) {
                        newExpressionText.append("java.lang.Float.NaN");
                    } else if (Float.isInfinite(v)) {
                        if (v > 0.0f) {
                            newExpressionText.append("java.lang.Float.POSITIVE_INFINITY");
                        } else {
                            newExpressionText.append("java.lang.Float.NEGATIVE_INFINITY");
                        }
                    } else {
                        newExpressionText.append(Float.toString(v)).append('f');
                    }
                } else {
                    newExpressionText.append(value2);
                }
                prevOperand = null;
                prevToken = null;
                continue;
            }
            if (prevToken != null) {
                newExpressionText.append(prevToken.getText());
            }
            if (prevOperand != null) {
                newExpressionText.append(prevOperand.getText());
            }
            prevOperand = operand2;
            prevToken = currentToken;
        }
        if (prevToken != null) {
            newExpressionText.append(prevToken.getText());
        }
        if (prevOperand != null) {
            newExpressionText.append(prevOperand.getText());
        }
        PsiReplacementUtil.replaceExpression((PsiExpression)polyadicExpression, newExpressionText.toString());
    }
}

