/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.enumswitch;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.enumswitch.EnumSwitchPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CreateEnumSwitchBranchesIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new EnumSwitchPredicate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiStatement[] statements;
        if (element instanceof PsiWhiteSpace) {
            element = element.getPrevSibling();
            assert (element != null);
        }
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)element;
        PsiCodeBlock body2 = switchStatement.getBody();
        PsiExpression switchExpression = switchStatement.getExpression();
        if (switchExpression == null) {
            return;
        }
        PsiClassType switchType = (PsiClassType)switchExpression.getType();
        if (switchType == null) {
            return;
        }
        PsiClass enumClass = switchType.resolve();
        if (enumClass == null) {
            return;
        }
        PsiField[] fields = enumClass.getFields();
        ArrayList<PsiEnumConstant> missingEnumElements = new ArrayList<PsiEnumConstant>(fields.length);
        for (PsiField psiField : fields) {
            if (!(psiField instanceof PsiEnumConstant)) continue;
            PsiEnumConstant enumConstant = (PsiEnumConstant)psiField;
            missingEnumElements.add(enumConstant);
        }
        if (body2 == null) {
            StringBuilder newStatementText = new StringBuilder();
            newStatementText.append("switch(").append(switchExpression.getText()).append("){");
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                newStatementText.append("case ").append(missingEnumElement.getName()).append(": break;");
            }
            newStatementText.append('}');
            PsiReplacementUtil.replaceStatement((PsiStatement)switchStatement, newStatementText.toString());
            return;
        }
        HashMap<PsiEnumConstant, PsiEnumConstant> nextEnumConstants = new HashMap<PsiEnumConstant, PsiEnumConstant>(fields.length);
        PsiEnumConstant previous = null;
        for (PsiEnumConstant psiEnumConstant : missingEnumElements) {
            if (previous != null) {
                nextEnumConstants.put(previous, psiEnumConstant);
            }
            previous = psiEnumConstant;
        }
        for (PsiStatement statement2 : statements = body2.getStatements()) {
            missingEnumElements.remove(CreateEnumSwitchBranchesIntention.findEnumConstant((PsiElement)statement2));
        }
        PsiEnumConstant psiEnumConstant = CreateEnumSwitchBranchesIntention.getNextEnumConstant(nextEnumConstants, missingEnumElements);
        for (PsiElement bodyElement = body2.getFirstBodyElement(); bodyElement != null; bodyElement = bodyElement.getNextSibling()) {
            void var12_21;
            while (var12_21 != null && CreateEnumSwitchBranchesIntention.findEnumConstant(bodyElement) == var12_21) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore((PsiEnumConstant)missingEnumElements.get(0), bodyElement);
                missingEnumElements.remove(0);
                if (missingEnumElements.isEmpty()) break;
                PsiEnumConstant psiEnumConstant2 = CreateEnumSwitchBranchesIntention.getNextEnumConstant(nextEnumConstants, missingEnumElements);
            }
            if (!CreateEnumSwitchBranchesIntention.isDefaultSwitchLabelStatement(bodyElement)) continue;
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore(missingEnumElement, bodyElement);
            }
            missingEnumElements.clear();
            break;
        }
        if (!missingEnumElements.isEmpty()) {
            PsiElement lastChild = body2.getLastChild();
            for (PsiEnumConstant missingEnumElement : missingEnumElements) {
                CreateEnumSwitchBranchesIntention.addSwitchLabelStatementBefore(missingEnumElement, lastChild);
            }
        }
    }

    private static void addSwitchLabelStatementBefore(PsiEnumConstant missingEnumElement, PsiElement anchor) {
        if (anchor instanceof PsiSwitchLabelStatement) {
            PsiElement sibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class});
            while (sibling instanceof PsiSwitchLabelStatement) {
                anchor = sibling;
                sibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)anchor, (Class[])new Class[]{PsiWhiteSpace.class});
            }
        }
        PsiElement parent = anchor.getParent();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)anchor.getProject());
        PsiStatement caseStatement = factory.createStatementFromText("case " + missingEnumElement.getName() + ":", anchor);
        parent.addBefore((PsiElement)caseStatement, anchor);
        PsiStatement breakStatement = factory.createStatementFromText("break;", anchor);
        parent.addBefore((PsiElement)breakStatement, anchor);
    }

    private static PsiEnumConstant findEnumConstant(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return null;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        PsiExpression value2 = switchLabelStatement.getCaseValue();
        if (!(value2 instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)value2;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiEnumConstant)) {
            return null;
        }
        return (PsiEnumConstant)target;
    }

    private static PsiEnumConstant getNextEnumConstant(Map<PsiEnumConstant, PsiEnumConstant> nextEnumConstants, List<PsiEnumConstant> missingEnumElements) {
        PsiEnumConstant nextEnumConstant = nextEnumConstants.get(missingEnumElements.get(0));
        while (missingEnumElements.contains(nextEnumConstant)) {
            nextEnumConstant = nextEnumConstants.get(nextEnumConstant);
        }
        return nextEnumConstant;
    }

    private static boolean isDefaultSwitchLabelStatement(PsiElement element) {
        if (!(element instanceof PsiSwitchLabelStatement)) {
            return false;
        }
        PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)element;
        return switchLabelStatement.isDefaultCase();
    }
}

