/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.expression;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementEditorPredicate;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.PsiSelectionSearcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipSetterCallIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        List<PsiMethodCallExpression> methodCalls;
        Project project2 = element.getProject();
        Editor editor = FileEditorManager.getInstance((Project)project2).getSelectedTextEditor();
        if (editor != null && (methodCalls = PsiSelectionSearcher.searchElementsInSelection(editor, project2, PsiMethodCallExpression.class, false)).size() > 0) {
            for (PsiMethodCallExpression call : methodCalls) {
                FlipSetterCallIntention.flipCall(call);
            }
            editor.getSelectionModel().removeSelection();
            return;
        }
        if (element instanceof PsiMethodCallExpression) {
            FlipSetterCallIntention.flipCall((PsiMethodCallExpression)element);
        }
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new SetterCallPredicate();
    }

    private static void flipCall(PsiMethodCallExpression call) {
        PsiExpression qualifierExpression1 = call.getMethodExpression().getQualifierExpression();
        if (qualifierExpression1 == null) {
            return;
        }
        PsiExpression[] arguments = call.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return;
        }
        PsiExpression argument = arguments[0];
        if (!(argument instanceof PsiMethodCallExpression)) {
            return;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)argument;
        PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifierExpression2 == null) {
            return;
        }
        PsiMethod setter = call.resolveMethod();
        PsiMethod getter = methodCallExpression.resolveMethod();
        PsiMethod get = PropertyUtil.getReversePropertyMethod((PsiMethod)setter);
        PsiMethod set2 = PropertyUtil.getReversePropertyMethod((PsiMethod)getter);
        if (get == null || set2 == null) {
            return;
        }
        String text = qualifierExpression2.getText() + "." + set2.getName() + "(" + qualifierExpression1.getText() + "." + get.getName() + "())";
        PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)call.getProject()).createExpressionFromText(text, (PsiElement)call);
        call.replace((PsiElement)newExpression);
    }

    private static boolean isSetGetMethodCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call1 = (PsiMethodCallExpression)element;
        PsiExpression[] arguments = call1.getArgumentList().getExpressions();
        if (arguments.length != 1) {
            return false;
        }
        PsiExpression argument = arguments[0];
        if (!(argument instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call2 = (PsiMethodCallExpression)argument;
        PsiMethod setter = call1.resolveMethod();
        PsiMethod getter = call2.resolveMethod();
        PsiMethod get = PropertyUtil.getReversePropertyMethod((PsiMethod)setter);
        PsiMethod set2 = PropertyUtil.getReversePropertyMethod((PsiMethod)getter);
        if (setter == null || getter == null || get == null || set2 == null) {
            return false;
        }
        PsiParameter[] parameters2 = setter.getParameterList().getParameters();
        if (parameters2.length != 1) {
            return false;
        }
        PsiParameter parameter = parameters2[0];
        return parameter.getType().equals(getter.getReturnType());
    }

    private static class SetterCallPredicate
    extends PsiElementEditorPredicate {
        private SetterCallPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element, @Nullable Editor editor) {
            if (editor != null && editor.getSelectionModel().hasSelection()) {
                List<PsiMethodCallExpression> list = PsiSelectionSearcher.searchElementsInSelection(editor, element.getProject(), PsiMethodCallExpression.class, false);
                for (PsiMethodCallExpression methodCallExpression : list) {
                    if (!FlipSetterCallIntention.isSetGetMethodCall((PsiElement)methodCallExpression)) continue;
                    return true;
                }
            }
            return FlipSetterCallIntention.isSetGetMethodCall(element);
        }
    }
}

