/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.IndexedForEachLoopPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceForEachLoopWithIndexedForLoopIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        return new IndexedForEachLoopPredicate();
    }

    @Override
    public void processIntention(@NotNull PsiElement element) {
        PsiForeachStatement statement2 = (PsiForeachStatement)element.getParent();
        if (statement2 == null) {
            return;
        }
        PsiExpression iteratedValue2 = statement2.getIteratedValue();
        if (iteratedValue2 == null) {
            return;
        }
        PsiParameter iterationParameter = statement2.getIterationParameter();
        PsiType type2 = iterationParameter.getType();
        PsiType iteratedValueType = iteratedValue2.getType();
        if (iteratedValueType == null) {
            return;
        }
        boolean isArray = iteratedValueType instanceof PsiArrayType;
        PsiElement grandParent = statement2.getParent();
        Object context = grandParent instanceof PsiLabeledStatement ? (PsiStatement)grandParent : statement2;
        String iteratedValueText = ReplaceForEachLoopWithIndexedForLoopIntention.getReferenceToIterate(iteratedValue2, (PsiElement)context);
        StringBuilder newStatement = new StringBuilder();
        String indexText = ReplaceForEachLoopWithIndexedForLoopIntention.createVariableName("i", (PsiType)PsiType.INT, (PsiElement)statement2);
        this.createForLoopDeclaration(statement2, iteratedValue2, isArray, iteratedValueText, newStatement, indexText);
        Project project2 = statement2.getProject();
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getSettings((Project)project2);
        if (codeStyleSettings.GENERATE_FINAL_LOCALS) {
            newStatement.append("final ");
        }
        newStatement.append(type2.getCanonicalText());
        newStatement.append(' ');
        newStatement.append(iterationParameter.getName());
        newStatement.append(" = ");
        newStatement.append(iteratedValueText);
        if (isArray) {
            newStatement.append('[');
            newStatement.append(indexText);
            newStatement.append("];");
        } else {
            newStatement.append(".get(");
            newStatement.append(indexText);
            newStatement.append(");");
        }
        PsiStatement body2 = statement2.getBody();
        if (body2 == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiCodeBlock block = ((PsiBlockStatement)body2).getCodeBlock();
            PsiElement[] children2 = block.getChildren();
            for (int i2 = 1; i2 < children2.length - 1; ++i2) {
                newStatement.append(children2[i2].getText());
            }
        } else {
            newStatement.append(body2.getText());
        }
        newStatement.append('}');
        PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement2, newStatement.toString());
    }

    protected void createForLoopDeclaration(PsiForeachStatement statement2, PsiExpression iteratedValue2, boolean array, String iteratedValueText, StringBuilder newStatement, String indexText) {
        newStatement.append("for(int ");
        newStatement.append(indexText);
        newStatement.append(" = 0; ");
        newStatement.append(indexText);
        newStatement.append('<');
        if (iteratedValue2 instanceof PsiTypeCastExpression) {
            newStatement.append('(');
            newStatement.append(iteratedValueText);
            newStatement.append(')');
        } else {
            newStatement.append(iteratedValueText);
        }
        if (array) {
            newStatement.append(".length");
        } else {
            newStatement.append(".size()");
        }
        newStatement.append(';');
        newStatement.append(indexText);
        newStatement.append("++)");
        newStatement.append("{ ");
    }

    @Nullable
    private static String getVariableName(PsiExpression expression2) {
        if (expression2 instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String name = methodExpression.getReferenceName();
            if (name == null) {
                return null;
            }
            if (name.startsWith("to") && name.length() > 2) {
                return StringUtil.decapitalize((String)name.substring(2));
            }
            if (name.startsWith("get") && name.length() > 3) {
                return StringUtil.decapitalize((String)name.substring(3));
            }
            return name;
        }
        if (expression2 instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression2;
            PsiExpression operand2 = castExpression.getOperand();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(operand2);
        }
        if (expression2 instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccessExpression = (PsiArrayAccessExpression)expression2;
            PsiExpression arrayExpression = arrayAccessExpression.getArrayExpression();
            String name = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(arrayExpression);
            return name == null ? null : StringUtil.unpluralize((String)name);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(innerExpression);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression2;
            String referenceName = referenceElement.getReferenceName();
            if (referenceName == null) {
                return expression2.getText();
            }
            return referenceName;
        }
        return null;
    }

    private static String getReferenceToIterate(PsiExpression expression2, PsiElement context) {
        if (expression2 instanceof PsiMethodCallExpression || expression2 instanceof PsiTypeCastExpression || expression2 instanceof PsiArrayAccessExpression || expression2 instanceof PsiNewExpression) {
            String variableName = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(expression2);
            return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName, expression2, context);
        }
        if (expression2 instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression2;
            PsiExpression innerExpression = parenthesizedExpression.getExpression();
            return ReplaceForEachLoopWithIndexedForLoopIntention.getReferenceToIterate(innerExpression, context);
        }
        if (expression2 instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)expression2;
            String variableName = ReplaceForEachLoopWithIndexedForLoopIntention.getVariableName(expression2);
            if (referenceElement.isQualified()) {
                return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName, expression2, context);
            }
            PsiElement target = referenceElement.resolve();
            if (target instanceof PsiVariable) {
                return variableName;
            }
            return ReplaceForEachLoopWithIndexedForLoopIntention.createVariable(variableName, expression2, context);
        }
        return expression2.getText();
    }

    private static String createVariable(String variableNameRoot, PsiExpression iteratedValue2, PsiElement context) {
        String variableName = ReplaceForEachLoopWithIndexedForLoopIntention.createVariableName(variableNameRoot, iteratedValue2);
        Project project2 = context.getProject();
        PsiType iteratedValueType = iteratedValue2.getType();
        assert (iteratedValueType != null);
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiDeclarationStatement declarationStatement = elementFactory.createVariableDeclarationStatement(variableName, iteratedValueType, iteratedValue2);
        PsiElement newElement = context.getParent().addBefore((PsiElement)declarationStatement, context);
        JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(newElement);
        return variableName;
    }

    public static String createVariableName(@Nullable String baseName, @NotNull PsiExpression assignedExpression) {
        Project project2 = assignedExpression.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        SuggestedNameInfo names = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, baseName, assignedExpression, null);
        if (names.names.length == 0) {
            return codeStyleManager.suggestUniqueVariableName(baseName, (PsiElement)assignedExpression, true);
        }
        return codeStyleManager.suggestUniqueVariableName(names.names[0], (PsiElement)assignedExpression, true);
    }

    public static String createVariableName(@Nullable String baseName, @NotNull PsiType type2, @NotNull PsiElement context) {
        Project project2 = context.getProject();
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
        SuggestedNameInfo names = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, baseName, null, type2);
        if (names.names.length == 0) {
            return codeStyleManager.suggestUniqueVariableName(baseName, context, true);
        }
        return codeStyleManager.suggestUniqueVariableName(names.names[0], context, true);
    }
}

