/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.forloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.ig.psiutils.BlockUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.forloop.ForLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceForLoopWithWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ForLoopPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiCodeBlock newBody;
        PsiBlockStatement blockStatement;
        PsiForStatement forStatement = (PsiForStatement)element.getParent();
        if (forStatement == null) {
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        PsiWhileStatement whileStatement = (PsiWhileStatement)factory.createStatementFromText("while(true) {}", element);
        PsiExpression forCondition = forStatement.getCondition();
        PsiExpression whileCondition = whileStatement.getCondition();
        PsiStatement body2 = forStatement.getBody();
        if (forCondition != null) {
            assert (whileCondition != null);
            whileCondition.replace((PsiElement)forCondition);
        }
        if ((blockStatement = (PsiBlockStatement)whileStatement.getBody()) == null) {
            return;
        }
        if (body2 instanceof PsiBlockStatement) {
            PsiBlockStatement newWhileBody = (PsiBlockStatement)blockStatement.replace((PsiElement)body2);
            newBody = newWhileBody.getCodeBlock();
        } else {
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            if (body2 != null && !(body2 instanceof PsiEmptyStatement)) {
                codeBlock.addAfter((PsiElement)body2, codeBlock.getFirstChild());
            }
            newBody = codeBlock;
        }
        PsiStatement update2 = forStatement.getUpdate();
        if (update2 != null) {
            PsiStatement[] updateStatements;
            if (update2 instanceof PsiExpressionListStatement) {
                PsiExpressionListStatement expressionListStatement = (PsiExpressionListStatement)update2;
                PsiExpressionList expressionList = expressionListStatement.getExpressionList();
                PsiExpression[] expressions2 = expressionList.getExpressions();
                updateStatements = new PsiStatement[expressions2.length];
                for (PsiExpression expression2 : expressions2) {
                    PsiStatement updateStatement;
                    updateStatements[i] = updateStatement = factory.createStatementFromText(expression2.getText() + ';', element);
                }
            } else {
                PsiStatement updateStatement = factory.createStatementFromText(update2.getText() + ';', element);
                updateStatements = new PsiStatement[]{updateStatement};
            }
            newBody.accept((PsiElementVisitor)new UpdateInserter(whileStatement, updateStatements));
            for (PsiStatement updateStatement : updateStatements) {
                newBody.addBefore((PsiElement)updateStatement, newBody.getLastChild());
            }
        }
        if (initialization == null || initialization instanceof PsiEmptyStatement) {
            return;
        }
        initialization = (PsiStatement)initialization.copy();
        PsiElement newElement = forStatement.replace((PsiElement)whileStatement);
        BlockUtils.addBefore((PsiStatement)newElement, initialization);
    }

    private static class UpdateInserter
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiWhileStatement whileStatement;
        private final PsiStatement[] updateStatements;

        private UpdateInserter(PsiWhileStatement whileStatement, PsiStatement[] updateStatements) {
            this.whileStatement = whileStatement;
            this.updateStatements = updateStatements;
        }

        public void visitContinueStatement(PsiContinueStatement statement2) {
            PsiStatement continuedStatement = statement2.findContinuedStatement();
            if (!this.whileStatement.equals(continuedStatement)) {
                return;
            }
            PsiElement parent = statement2.getParent();
            if (parent == null) {
                return;
            }
            for (PsiStatement updateStatement : this.updateStatements) {
                parent.addBefore((PsiElement)updateStatement, (PsiElement)statement2);
            }
            super.visitContinueStatement(statement2);
        }
    }
}

