/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ipp.base.Intention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConvertNumberIntentionBase
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        boolean negated;
        PsiExpression expression2 = (PsiExpression)element;
        Number value2 = (Number)ExpressionUtils.computeConstantExpression(expression2);
        if (value2 == null) {
            return;
        }
        PsiType type2 = expression2.getType();
        String resultString = this.convertValue(value2, type2, negated = ExpressionUtils.isNegative(expression2));
        if (resultString == null) {
            return;
        }
        if (negated) {
            PsiReplacementUtil.replaceExpression((PsiExpression)expression2.getParent(), resultString);
        } else {
            PsiReplacementUtil.replaceExpression(expression2, resultString);
        }
    }

    @Nullable
    protected abstract String convertValue(Number var1, PsiType var2, boolean var3);
}

