/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.integer.ConvertNumberIntentionBase;
import com.siyeh.ipp.integer.ConvertToScientificNotationPredicate;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class ConvertToScientificNotationIntention
extends ConvertNumberIntentionBase {
    private static final DecimalFormat FORMAT = new DecimalFormat("0.0#############E00", new DecimalFormatSymbols(Locale.US));

    @Override
    protected String convertValue(Number value2, PsiType type2, boolean negated) {
        double doubleValue = Double.parseDouble(value2.toString());
        String text = FORMAT.format(negated ? -doubleValue : doubleValue);
        return PsiType.FLOAT.equals((Object)type2) ? text + "f" : text;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new ConvertToScientificNotationPredicate();
    }
}

