/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.integer;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ipp.base.PsiElementPredicate;

class ConvertToScientificNotationPredicate
implements PsiElementPredicate {
    ConvertToScientificNotationPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiLiteralExpression)) {
            return false;
        }
        PsiLiteralExpression expression2 = (PsiLiteralExpression)element;
        PsiType type2 = expression2.getType();
        if (!PsiType.DOUBLE.equals((Object)type2) && !PsiType.FLOAT.equals((Object)type2)) {
            return false;
        }
        String text = expression2.getText();
        if (text == null) {
            return false;
        }
        text = text.toLowerCase();
        if (!(text = StringUtil.trimStart((String)text, (String)"-")).contains(".") && text.startsWith("0")) {
            return false;
        }
        return !text.contains("e");
    }
}

