/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class AssertEqualsWithLiteralPredicate
implements PsiElementPredicate {
    AssertEqualsWithLiteralPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression expression2 = (PsiMethodCallExpression)element;
        PsiExpressionList argumentList = expression2.getArgumentList();
        PsiExpression[] arguments = argumentList.getExpressions();
        int argumentCount = arguments.length;
        if (argumentCount < 2 || argumentCount > 3) {
            return false;
        }
        PsiReferenceExpression methodExpression = expression2.getMethodExpression();
        String methodName = methodExpression.getReferenceName();
        if (!"assertEquals".equals(methodName)) {
            return false;
        }
        if (ErrorUtil.containsError(element)) {
            return false;
        }
        PsiMethod method2 = expression2.resolveMethod();
        if (method2 == null) {
            return false;
        }
        PsiClass targetClass = method2.getContainingClass();
        if (targetClass == null) {
            return false;
        }
        String qualifiedName = targetClass.getQualifiedName();
        if (!"junit.framework.Assert".equals(qualifiedName) && !"org.junit.Assert".equals(qualifiedName)) {
            return false;
        }
        if (argumentCount == 2) {
            return AssertEqualsWithLiteralPredicate.isSpecialLiteral(arguments[0]) || AssertEqualsWithLiteralPredicate.isSpecialLiteral(arguments[1]);
        }
        return AssertEqualsWithLiteralPredicate.isSpecialLiteral(arguments[1]) || AssertEqualsWithLiteralPredicate.isSpecialLiteral(arguments[2]);
    }

    private static boolean isSpecialLiteral(PsiExpression expression2) {
        if (expression2 == null) {
            return false;
        }
        String text = expression2.getText();
        return "true".equals(text) || "false".equals(text) || "null".equals(text);
    }
}

