/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.IntentionPowerPackBundle;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ipp.base.MutablyNamedIntention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class PostfixPrefixIntention
extends MutablyNamedIntention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                IElementType tokenType;
                if (element instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
                    tokenType = prefixExpression.getOperationTokenType();
                    if (prefixExpression.getOperand() == null) {
                        return false;
                    }
                } else if (element instanceof PsiPostfixExpression) {
                    PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
                    tokenType = postfixExpression.getOperationTokenType();
                } else {
                    return false;
                }
                return JavaTokenType.PLUSPLUS.equals(tokenType) || JavaTokenType.MINUSMINUS.equals(tokenType);
            }
        };
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        return IntentionPowerPackBundle.message("postfix.prefix.intention.name", PostfixPrefixIntention.getReplacementText(element));
    }

    @NotNull
    private static String getReplacementText(PsiElement element) {
        if (element instanceof PsiPrefixExpression) {
            PsiPrefixExpression prefixExpression = (PsiPrefixExpression)element;
            PsiExpression operand2 = prefixExpression.getOperand();
            assert (operand2 != null);
            PsiJavaToken sign = prefixExpression.getOperationSign();
            return operand2.getText() + sign.getText();
        }
        PsiPostfixExpression postfixExpression = (PsiPostfixExpression)element;
        PsiExpression operand3 = postfixExpression.getOperand();
        PsiJavaToken sign = postfixExpression.getOperationSign();
        return sign.getText() + operand3.getText();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        PsiExpression expression2 = (PsiExpression)element;
        PsiReplacementUtil.replaceExpression(expression2, PostfixPrefixIntention.getReplacementText(element));
    }
}

