/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ipp.base.PsiElementPredicate;

class ReplaceAssignmentWithPostfixExpressionPredicate
implements PsiElementPredicate {
    private static final Integer ONE = 1;

    ReplaceAssignmentWithPostfixExpressionPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)element;
        PsiExpression lhs = assignmentExpression.getLExpression();
        PsiExpression strippedLhs = ParenthesesUtils.stripParentheses(lhs);
        if (!(strippedLhs instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)strippedLhs;
        PsiElement target = referenceExpression.resolve();
        if (!(target instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)target;
        PsiExpression rhs = assignmentExpression.getRExpression();
        if (!(rhs instanceof PsiBinaryExpression)) {
            return false;
        }
        PsiBinaryExpression binaryExpression = (PsiBinaryExpression)rhs;
        PsiExpression rOperand = binaryExpression.getROperand();
        if (rOperand == null) {
            return false;
        }
        PsiExpression lOperand = binaryExpression.getLOperand();
        IElementType tokenType = binaryExpression.getOperationTokenType();
        if (lOperand instanceof PsiLiteral) {
            PsiLiteral literal = (PsiLiteral)lOperand;
            Object value2 = literal.getValue();
            if (ONE != value2) {
                return false;
            }
            if (!VariableAccessUtils.evaluatesToVariable(rOperand, variable)) {
                return false;
            }
            return JavaTokenType.PLUS.equals(tokenType);
        }
        if (rOperand instanceof PsiLiteral) {
            PsiLiteral literal = (PsiLiteral)rOperand;
            Object value3 = literal.getValue();
            if (ONE != value3) {
                return false;
            }
            if (!VariableAccessUtils.evaluatesToVariable(lOperand, variable)) {
                return false;
            }
            return JavaTokenType.PLUS.equals(tokenType) || JavaTokenType.MINUS.equals(tokenType);
        }
        return false;
    }
}

