/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.shift;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.shift.ShiftUtils;

class ShiftByLiteralPredicate
implements PsiElementPredicate {
    ShiftByLiteralPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (element instanceof PsiBinaryExpression) {
            return ShiftByLiteralPredicate.isBinaryShiftByLiteral((PsiBinaryExpression)element);
        }
        if (element instanceof PsiAssignmentExpression) {
            return ShiftByLiteralPredicate.isAssignmentShiftByLiteral((PsiAssignmentExpression)element);
        }
        return false;
    }

    private static boolean isAssignmentShiftByLiteral(PsiAssignmentExpression expression2) {
        IElementType tokenType = expression2.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.LTLTEQ) && !tokenType.equals(JavaTokenType.GTGTEQ)) {
            return false;
        }
        PsiExpression lhs = expression2.getLExpression();
        PsiType lhsType = lhs.getType();
        if (lhsType == null) {
            return false;
        }
        if (!ShiftUtils.isIntegral(lhsType)) {
            return false;
        }
        PsiExpression rhs = expression2.getRExpression();
        if (rhs == null) {
            return false;
        }
        return ShiftUtils.isIntLiteral(rhs);
    }

    private static boolean isBinaryShiftByLiteral(PsiBinaryExpression expression2) {
        IElementType tokenType = expression2.getOperationTokenType();
        if (!tokenType.equals(JavaTokenType.LTLT) && !tokenType.equals(JavaTokenType.GTGT)) {
            return false;
        }
        PsiExpression lOperand = expression2.getLOperand();
        PsiType lhsType = lOperand.getType();
        if (!ShiftUtils.isIntegral(lhsType)) {
            return false;
        }
        PsiExpression rhs = expression2.getROperand();
        return ShiftUtils.isIntLiteral(rhs);
    }
}

