/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.varargs;

import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

class VarargArgumentsPredicate
implements PsiElementPredicate {
    VarargArgumentsPredicate() {
    }

    @Override
    public boolean satisfiedBy(@NotNull PsiElement element) {
        String text;
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList typeParameterList;
        if (!(element instanceof PsiExpressionList)) {
            return false;
        }
        PsiExpressionList argumentList = (PsiExpressionList)element;
        PsiElement grandParent = argumentList.getParent();
        if (!(grandParent instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
        PsiMethod method2 = methodCallExpression.resolveMethod();
        if (method2 == null || !method2.isVarArgs()) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        PsiExpression[] arguments = argumentList.getExpressions();
        if (arguments.length < parametersCount) {
            return false;
        }
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        if (qualifier == null && (typeParameterList = methodExpression.getParameterList()) != null && (typeParameterElements = typeParameterList.getTypeParameterElements()).length > 0) {
            return false;
        }
        if (arguments.length != parametersCount) {
            return true;
        }
        PsiExpression lastExpression = arguments[arguments.length - 1];
        PsiExpression expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)lastExpression);
        if (expression2 instanceof PsiLiteralExpression && "null".equals(text = expression2.getText())) {
            return false;
        }
        PsiType lastArgumentType = lastExpression.getType();
        if (!(lastArgumentType instanceof PsiArrayType)) {
            return true;
        }
        PsiArrayType arrayType = (PsiArrayType)lastArgumentType;
        PsiType type2 = arrayType.getComponentType();
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiParameter lastParameter = parameters2[parameters2.length - 1];
        PsiEllipsisType lastParameterType = (PsiEllipsisType)lastParameter.getType();
        PsiType lastType = lastParameterType.getComponentType();
        JavaResolveResult resolveResult = methodCallExpression.resolveMethodGenerics();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        PsiType substitutedType = substitutor.substitute(lastType);
        return !substitutedType.equals(type2);
    }
}

