/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.WhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ExtractWhileLoopConditionToIfStatementIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new WhileLoopPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement newElement;
        PsiBlockStatement blockStatement;
        PsiWhileStatement whileStatement = (PsiWhileStatement)element.getParent();
        if (whileStatement == null) {
            return;
        }
        PsiExpression condition2 = whileStatement.getCondition();
        if (condition2 == null) {
            return;
        }
        String conditionText = condition2.getText();
        PsiManager manager = whileStatement.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        PsiExpression newCondition = factory.createExpressionFromText("true", (PsiElement)whileStatement);
        condition2.replace((PsiElement)newCondition);
        PsiStatement body2 = whileStatement.getBody();
        String ifStatementText = "if (!(" + conditionText + ")) break;";
        PsiStatement ifStatement = factory.createStatementFromText(ifStatementText, (PsiElement)whileStatement);
        if (body2 instanceof PsiBlockStatement) {
            blockStatement = (PsiBlockStatement)body2;
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            PsiElement bodyElement = codeBlock.getFirstBodyElement();
            newElement = codeBlock.addBefore((PsiElement)ifStatement, bodyElement);
        } else if (body2 != null) {
            blockStatement = (PsiBlockStatement)factory.createStatementFromText("{}", (PsiElement)whileStatement);
            PsiCodeBlock codeBlock = blockStatement.getCodeBlock();
            codeBlock.add((PsiElement)ifStatement);
            if (!(body2 instanceof PsiEmptyStatement)) {
                codeBlock.add((PsiElement)body2);
            }
            newElement = body2.replace((PsiElement)blockStatement);
        } else {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        codeStyleManager.reformat(newElement);
    }
}

