/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.whileloop;

import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.whileloop.DoWhileLoopPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceDoWhileLoopWithWhileLoopIntention
extends Intention {
    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        return new DoWhileLoopPredicate();
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        int i2;
        PsiCodeBlock codeBlock;
        PsiBlockStatement blockStatement;
        boolean noBraces;
        PsiDoWhileStatement doWhileStatement = (PsiDoWhileStatement)element.getParent();
        if (doWhileStatement == null) {
            return;
        }
        PsiStatement body2 = doWhileStatement.getBody();
        PsiElement parent = doWhileStatement.getParent();
        PsiExpression condition2 = doWhileStatement.getCondition();
        StringBuilder replacementText = new StringBuilder();
        if (BoolUtils.isTrue(condition2)) {
            replacementText.append("while(").append(condition2.getText()).append(')');
            if (body2 != null) {
                replacementText.append(body2.getText());
            }
            PsiReplacementUtil.replaceStatement((PsiStatement)doWhileStatement, replacementText.toString());
            return;
        }
        boolean bl = noBraces = !(parent instanceof PsiCodeBlock);
        if (noBraces) {
            PsiElement[] parentChildren;
            for (PsiElement child : parentChildren = parent.getChildren()) {
                if (child == doWhileStatement) break;
                replacementText.append(child.getText());
            }
            replacementText.append('{');
        }
        if (body2 instanceof PsiBlockStatement) {
            blockStatement = (PsiBlockStatement)body2;
            codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children2 = codeBlock.getChildren();
            if (children2.length > 2) {
                int length = children2.length - 1;
                for (i2 = 1; i2 < length; ++i2) {
                    PsiElement child = children2[i2];
                    if (child instanceof PsiDeclarationStatement) {
                        PsiElement[] declaredElements;
                        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)child;
                        PsiElement[] psiElementArray = declaredElements = declarationStatement.getDeclaredElements();
                        int n = psiElementArray.length;
                        for (int j = 0; j < n; ++j) {
                            PsiVariable variable;
                            PsiModifierList modifierList;
                            PsiElement declaredElement = psiElementArray[j];
                            if (!(declaredElement instanceof PsiVariable) || (modifierList = (variable = (PsiVariable)declaredElement).getModifierList()) == null) continue;
                            modifierList.setModifierProperty("final", false);
                        }
                    }
                    if (noBraces) {
                        replacementText.append(child.getText());
                        continue;
                    }
                    parent.addBefore(child, (PsiElement)doWhileStatement);
                }
            }
        } else if (body2 != null) {
            if (noBraces) {
                replacementText.append(body2.getText());
            } else {
                parent.addBefore((PsiElement)body2, (PsiElement)doWhileStatement);
            }
        }
        replacementText.append("while(");
        if (condition2 != null) {
            replacementText.append(condition2.getText());
        }
        replacementText.append(')');
        if (body2 instanceof PsiBlockStatement) {
            replacementText.append('{');
            blockStatement = (PsiBlockStatement)body2;
            codeBlock = blockStatement.getCodeBlock();
            PsiElement[] children3 = codeBlock.getChildren();
            if (children3.length > 2) {
                for (i2 = 1; i2 < children3.length - 1; ++i2) {
                    PsiElement child;
                    child = children3[i2];
                    if (child instanceof PsiDeclarationStatement) {
                        PsiElement[] declaredElements;
                        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)child;
                        for (PsiElement declaredElement : declaredElements = declarationStatement.getDeclaredElements()) {
                            PsiVariable variable;
                            PsiExpression initializer;
                            if (!(declaredElement instanceof PsiVariable) || (initializer = (variable = (PsiVariable)declaredElement).getInitializer()) == null) continue;
                            replacementText.append(variable.getName()).append(" = ").append(initializer.getText()).append(';');
                        }
                        continue;
                    }
                    replacementText.append(child.getText());
                }
            }
            replacementText.append('}');
        } else if (body2 != null) {
            replacementText.append(body2.getText());
        }
        if (noBraces) {
            replacementText.append('}');
        }
        if (noBraces) {
            PsiReplacementUtil.replaceStatement((PsiStatement)parent, replacementText.toString());
        } else {
            PsiReplacementUtil.replaceStatement((PsiStatement)doWhileStatement, replacementText.toString());
        }
    }
}

