/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;

public class ImageInfoIndex
extends SingleEntryFileBasedIndexExtension<ImageInfo> {
    private static final int ourMaxImageSize;
    public static final ID<Integer, ImageInfo> INDEX_ID;
    private final DataExternalizer<ImageInfo> myValueExternalizer = new DataExternalizer<ImageInfo>(){

        public void save(@NotNull DataOutput out, ImageInfo info) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.width);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.height);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.bpp);
        }

        public ImageInfo read(@NotNull DataInput in) throws IOException {
            return new ImageInfo(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in));
        }
    };
    private final SingleEntryIndexer<ImageInfo> myDataIndexer = new SingleEntryIndexer<ImageInfo>(false){

        @Override
        protected ImageInfo computeValue(@NotNull FileContent inputData) {
            ImageInfoReader.Info info = ImageInfoReader.getInfo(inputData.getContent());
            return info != null ? new ImageInfo(info.width, info.height, info.bpp) : null;
        }
    };

    @NotNull
    public ID<Integer, ImageInfo> getName() {
        return INDEX_ID;
    }

    @Override
    @NotNull
    public SingleEntryIndexer<ImageInfo> getIndexer() {
        return this.myDataIndexer;
    }

    public static void processValues(VirtualFile virtualFile, FileBasedIndex.ValueProcessor<ImageInfo> processor2, Project project2) {
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)Math.abs(FileBasedIndex.getFileId((VirtualFile)virtualFile)), virtualFile, processor2, GlobalSearchScope.fileScope((Project)project2, (VirtualFile)virtualFile));
    }

    @NotNull
    public DataExternalizer<ImageInfo> getValueExternalizer() {
        return this.myValueExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                return file2.isInLocalFileSystem() && file2.getLength() / 1024L < (long)ourMaxImageSize;
            }
        };
    }

    public int getVersion() {
        return 5;
    }

    static {
        int maxImageSize = 200;
        try {
            maxImageSize = Integer.parseInt(System.getProperty("idea.max.image.filesize", Integer.toString(maxImageSize)), 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ourMaxImageSize = maxImageSize;
        INDEX_ID = ID.create((String)"ImageFileInfoIndex");
    }

    public static class ImageInfo {
        public int width;
        public int height;
        public int bpp;

        public ImageInfo(int width, int height, int bpp) {
            this.width = width;
            this.height = height;
            this.bpp = bpp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo imageInfo = (ImageInfo)o;
            if (this.bpp != imageInfo.bpp) {
                return false;
            }
            if (this.height != imageInfo.height) {
                return false;
            }
            return this.width == imageInfo.width;
        }

        public int hashCode() {
            int result2 = this.width;
            result2 = 31 * result2 + this.height;
            result2 = 31 * result2 + this.bpp;
            return result2;
        }
    }
}

