/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.thumbnail.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import javax.swing.JComponent;
import org.intellij.images.thumbnail.ThumbnailView;
import org.intellij.images.thumbnail.actionSystem.ThumbnailViewActionUtil;
import org.intellij.images.thumbnail.actions.FilterByThemeAction;
import org.intellij.images.thumbnail.actions.ThemeFilter;
import org.jetbrains.annotations.NotNull;

public final class FilterByThemeComboBoxAction
extends ComboBoxAction {
    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        ThumbnailView view = ThumbnailViewActionUtil.getVisibleThumbnailView(e);
        boolean hasApplicableExtension = Arrays.stream(ThemeFilter.EP_NAME.getExtensions()).allMatch(filter -> project2 != null && filter.isApplicableToProject(project2));
        e.getPresentation().setVisible(view != null && hasApplicableExtension);
        ThemeFilter filter2 = view != null ? view.getFilter() : null;
        e.getPresentation().setText(filter2 == null ? "All" : filter2.getDisplayName());
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(JComponent button) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new FilterByThemeAction(new ThemeFilter(){

            @Override
            public String getDisplayName() {
                return "All";
            }

            @Override
            public boolean accepts(VirtualFile file2) {
                return true;
            }

            @Override
            public boolean isApplicableToProject(Project project2) {
                return true;
            }
        }));
        for (ThemeFilter filter : (ThemeFilter[])ThemeFilter.EP_NAME.getExtensions()) {
            group.add((AnAction)new FilterByThemeAction(filter));
        }
        return group;
    }
}

