/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.RegExpHighlighter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RegExpColorsPage
implements ColorSettingsPage {
    private static final AttributesDescriptor[] DESCRIPTORS = new AttributesDescriptor[]{new AttributesDescriptor("Plain character", RegExpHighlighter.CHARACTER), new AttributesDescriptor("Operator character", RegExpHighlighter.META), new AttributesDescriptor("Escaped character", RegExpHighlighter.ESC_CHARACTER), new AttributesDescriptor("Invalid escape sequence", RegExpHighlighter.INVALID_CHARACTER_ESCAPE), new AttributesDescriptor("Redundant escape sequence", RegExpHighlighter.REDUNDANT_ESCAPE), new AttributesDescriptor("Brace", RegExpHighlighter.BRACES), new AttributesDescriptor("Bracket", RegExpHighlighter.BRACKETS), new AttributesDescriptor("Parenthesis", RegExpHighlighter.PARENTHS), new AttributesDescriptor("Comma", RegExpHighlighter.COMMA), new AttributesDescriptor("Bad character", RegExpHighlighter.BAD_CHARACTER), new AttributesDescriptor("Character class", RegExpHighlighter.CHAR_CLASS), new AttributesDescriptor("Quote character", RegExpHighlighter.QUOTE_CHARACTER), new AttributesDescriptor("Comment", RegExpHighlighter.COMMENT), new AttributesDescriptor("Quantifier", RegExpHighlighter.QUANTIFIER), new AttributesDescriptor("Dot", RegExpHighlighter.DOT), new AttributesDescriptor("Inline option", RegExpHighlighter.OPTIONS), new AttributesDescriptor("Name", RegExpHighlighter.NAME)};
    @NonNls
    private static final HashMap<String, TextAttributesKey> ourTagToDescriptorMap = new HashMap();

    @NotNull
    public String getDisplayName() {
        return "RegExp";
    }

    public Icon getIcon() {
        return RegExpFileType.INSTANCE.getIcon();
    }

    @NotNull
    public AttributesDescriptor[] getAttributeDescriptors() {
        return DESCRIPTORS;
    }

    @NotNull
    public ColorDescriptor[] getColorDescriptors() {
        return ColorDescriptor.EMPTY_ARRAY;
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)RegExpFileType.INSTANCE, null, null);
        assert (highlighter != null);
        return highlighter;
    }

    @NotNull
    public String getDemoText() {
        return "^[\\w\\.-]+@([\\w\\-]+|\\.)+[A-Z0-9]{2,4}(?x)\n\\x0g\\#\\p{Alpha}\\1(?#comment)\n.*\\Q...\\E$# end-of-line comment";
    }

    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return ourTagToDescriptorMap;
    }
}

