/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.impl.RegExpBackrefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBoundaryImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBranchImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharRangeImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClassImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClosureImpl;
import org.intellij.lang.regexp.psi.impl.RegExpGroupImpl;
import org.intellij.lang.regexp.psi.impl.RegExpIntersectionImpl;
import org.intellij.lang.regexp.psi.impl.RegExpNamedCharacterImpl;
import org.intellij.lang.regexp.psi.impl.RegExpNamedGroupRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpNumberImpl;
import org.intellij.lang.regexp.psi.impl.RegExpOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPatternImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPosixBracketExpressionImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPropertyImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPyCondRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpQuantifierImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSetOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSimpleClassImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpParserDefinition
implements ParserDefinition {
    private static final TokenSet WHITE_SPACE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.QUOTE_BEGIN, RegExpTT.QUOTE_END, TokenType.WHITE_SPACE});
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.COMMENT});
    private static final EnumSet<RegExpCapability> CAPABILITIES = EnumSet.of(RegExpCapability.NESTED_CHARACTER_CLASSES, RegExpCapability.ALLOW_HORIZONTAL_WHITESPACE_CLASS, RegExpCapability.UNICODE_CATEGORY_SHORTHAND, RegExpCapability.EXTENDED_UNICODE_CHARACTER);

    @NotNull
    public Lexer createLexer(Project project2) {
        return new RegExpLexer(CAPABILITIES);
    }

    public PsiParser createParser(Project project2) {
        return new RegExpParser(CAPABILITIES);
    }

    public IFileElementType getFileNodeType() {
        return RegExpElementTypes.REGEXP_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACE_TOKENS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENT_TOKENS;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 == RegExpElementTypes.PATTERN) {
            return new RegExpPatternImpl(node);
        }
        if (type2 == RegExpElementTypes.BRANCH) {
            return new RegExpBranchImpl(node);
        }
        if (type2 == RegExpElementTypes.SIMPLE_CLASS) {
            return new RegExpSimpleClassImpl(node);
        }
        if (type2 == RegExpElementTypes.CLASS) {
            return new RegExpClassImpl(node);
        }
        if (type2 == RegExpElementTypes.CHAR_RANGE) {
            return new RegExpCharRangeImpl(node);
        }
        if (type2 == RegExpElementTypes.CHAR) {
            return new RegExpCharImpl(node);
        }
        if (type2 == RegExpElementTypes.GROUP) {
            return new RegExpGroupImpl(node);
        }
        if (type2 == RegExpElementTypes.PROPERTY) {
            return new RegExpPropertyImpl(node);
        }
        if (type2 == RegExpElementTypes.NAMED_CHARACTER) {
            return new RegExpNamedCharacterImpl(node);
        }
        if (type2 == RegExpElementTypes.SET_OPTIONS) {
            return new RegExpSetOptionsImpl(node);
        }
        if (type2 == RegExpElementTypes.OPTIONS) {
            return new RegExpOptionsImpl(node);
        }
        if (type2 == RegExpElementTypes.BACKREF) {
            return new RegExpBackrefImpl(node);
        }
        if (type2 == RegExpElementTypes.CLOSURE) {
            return new RegExpClosureImpl(node);
        }
        if (type2 == RegExpElementTypes.QUANTIFIER) {
            return new RegExpQuantifierImpl(node);
        }
        if (type2 == RegExpElementTypes.BOUNDARY) {
            return new RegExpBoundaryImpl(node);
        }
        if (type2 == RegExpElementTypes.INTERSECTION) {
            return new RegExpIntersectionImpl(node);
        }
        if (type2 == RegExpElementTypes.NAMED_GROUP_REF) {
            return new RegExpNamedGroupRefImpl(node);
        }
        if (type2 == RegExpElementTypes.PY_COND_REF) {
            return new RegExpPyCondRefImpl(node);
        }
        if (type2 == RegExpElementTypes.POSIX_BRACKET_EXPRESSION) {
            return new RegExpPosixBracketExpressionImpl(node);
        }
        if (type2 == RegExpElementTypes.NUMBER) {
            return new RegExpNumberImpl(node);
        }
        return new ASTWrapperPsiElement(node);
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RegExpFile(viewProvider, RegExpLanguage.INSTANCE);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MUST_NOT;
    }
}

