/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import org.intellij.lang.regexp.inspection.RegExpEquivalenceChecker;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DuplicateAlternationBranchInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Duplicate branch in alternation";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new DuplicateAlternationBranchVisitor(holder);
    }

    private static class DuplicateAlternationBranchFix
    implements LocalQuickFix {
        private DuplicateAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Remove duplicate branch";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof RegExpBranch)) {
                return;
            }
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling != null) {
                prevSibling.delete();
            } else {
                PsiElement nextSibling = element.getNextSibling();
                if (nextSibling != null) {
                    nextSibling.delete();
                }
            }
            element.delete();
        }
    }

    private static class DuplicateAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public DuplicateAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            HashSet<RegExpBranch> reported = new HashSet<RegExpBranch>(2);
            RegExpBranch[] branches = pattern.getBranches();
            for (int i2 = 0; i2 < branches.length - 1; ++i2) {
                RegExpBranch branch1 = branches[i2];
                if (branch1.getAtoms().length == 0) continue;
                for (int j = i2 + 1; j < branches.length; ++j) {
                    RegExpBranch branch2 = branches[j];
                    if (!RegExpEquivalenceChecker.areElementsEquivalent(branch1, branch2)) continue;
                    if (reported.add(branch1)) {
                        this.myHolder.registerProblem((PsiElement)branch1, "Duplicate branch in alternation", new LocalQuickFix[]{new DuplicateAlternationBranchFix()});
                    }
                    if (!reported.add(branch2)) continue;
                    this.myHolder.registerProblem((PsiElement)branch2, "Duplicate branch in alternation", new LocalQuickFix[]{new DuplicateAlternationBranchFix()});
                }
            }
        }
    }
}

