/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OctalEscapeInspection
extends LocalInspectionTool {
    @Nls
    @NotNull
    public String getDisplayName() {
        return "Octal escape";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new OctalEscapeVisitor(holder);
    }

    static String buildReplacementText(RegExpChar aChar) {
        int value2 = aChar.getValue();
        String hex = Integer.toHexString(value2);
        String result2 = (hex.length() == 1 ? "\\x0" : "\\x") + hex;
        if (RegExpElementImpl.isLiteralExpression(aChar.getContainingFile().getContext())) {
            return StringUtil.escapeStringCharacters((String)result2);
        }
        return result2;
    }

    private static class ReplaceWithHexEscapeFix
    implements LocalQuickFix {
        private final String myHex;

        public ReplaceWithHexEscapeFix(String hex) {
            this.myHex = hex;
        }

        @Nls
        @NotNull
        public String getName() {
            return "Replace with '" + this.myHex + '\'';
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return "Replace with hexadecimal escape";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof RegExpChar)) {
                return;
            }
            ASTNode node = element.getNode();
            RegExpChar aChar = (RegExpChar)element;
            ASTNode anchor = node.getFirstChildNode();
            node.addLeaf(RegExpTT.HEX_CHAR, (CharSequence)OctalEscapeInspection.buildReplacementText(aChar), anchor);
            node.removeChild(anchor);
        }
    }

    private static class OctalEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        public OctalEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.OCT) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, "Octal escape <code>#ref</code> in RegExp", new LocalQuickFix[]{new ReplaceWithHexEscapeFix(OctalEscapeInspection.buildReplacementText(ch))});
        }
    }
}

