/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.codeInsight.intention.impl.QuickEditAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.intention.CheckRegExpForm;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpIntentionAction
extends QuickEditAction
implements Iconable {
    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        Pair<PsiElement, TextRange> pair = this.getRangePair(file2, editor);
        if (pair != null && pair.first != null) {
            Language language = ((PsiElement)pair.first).getLanguage();
            return language.isKindOf((Language)RegExpLanguage.INSTANCE);
        }
        PsiFile baseFile = InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile((PsiElement)file2);
        return baseFile != null && baseFile.getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE);
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiFile baseFile = InjectedLanguageManager.getInstance((Project)project2).getTopLevelFile((PsiElement)file2);
        if (baseFile == null || !baseFile.getLanguage().isKindOf((Language)RegExpLanguage.INSTANCE)) {
            super.invoke(project2, editor, file2);
            return;
        }
        JComponent component = this.createBalloonComponent(file2);
        if (component != null) {
            QuickEditHandler.showBalloon(editor, file2, component);
        }
    }

    @Override
    protected boolean isShowInBalloon() {
        return true;
    }

    @Override
    protected JComponent createBalloonComponent(@NotNull PsiFile file2) {
        Project project2 = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document != null) {
            return new CheckRegExpForm(file2).getRootPanel();
        }
        return null;
    }

    @Override
    @NotNull
    public String getText() {
        return "Check RegExp";
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public Icon getIcon(int flags) {
        return RegExpLanguage.INSTANCE.getAssociatedFileType().getIcon();
    }
}

