/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpCharImpl
extends RegExpElementImpl
implements RegExpChar {
    private static final TokenSet OCT_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.OCT_CHAR, RegExpTT.BAD_OCT_VALUE});
    private static final TokenSet HEX_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.HEX_CHAR, RegExpTT.BAD_HEX_VALUE});
    private static final TokenSet UNICODE_CHARS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.UNICODE_CHAR, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN});

    public RegExpCharImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public RegExpChar.Type getType() {
        ASTNode child = this.getNode().getFirstChildNode();
        assert (child != null);
        IElementType t = child.getElementType();
        if (OCT_CHARS.contains(t)) {
            return RegExpChar.Type.OCT;
        }
        if (HEX_CHARS.contains(t)) {
            return RegExpChar.Type.HEX;
        }
        if (UNICODE_CHARS.contains(t)) {
            return RegExpChar.Type.UNICODE;
        }
        if (t == RegExpTT.NAMED_CHARACTER) {
            return RegExpChar.Type.NAMED;
        }
        return RegExpChar.Type.CHAR;
    }

    @Override
    public int getValue() {
        String s = this.getUnescapedText();
        if (s.equals("\\") && this.getType() == RegExpChar.Type.CHAR) {
            return 92;
        }
        return RegExpCharImpl.unescapeChar(s);
    }

    private static int unescapeChar(String s) {
        int length = s.length();
        assert (length > 0);
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch != '\\') {
                    return ch;
                }
            } else {
                switch (ch) {
                    case 'n': {
                        return 10;
                    }
                    case 'r': {
                        return 13;
                    }
                    case 't': {
                        return 9;
                    }
                    case 'a': {
                        return 7;
                    }
                    case 'e': {
                        return 27;
                    }
                    case 'f': {
                        return 12;
                    }
                    case 'b': {
                        return 8;
                    }
                    case 'c': {
                        return (char)(ch ^ 0x40);
                    }
                    case 'N': {
                        if (length < idx + 3 || s.charAt(idx + 1) != '{' || s.charAt(length - 1) != '}') {
                            return -1;
                        }
                        int codePoint = UnicodeCharacterNames.getCodePoint(s.substring(idx + 2, length - 1));
                        if (codePoint == -1) {
                            return -1;
                        }
                        return codePoint;
                    }
                    case 'x': {
                        if (length <= idx + 1) {
                            return -1;
                        }
                        if (s.charAt(idx + 1) == '{') {
                            char c = s.charAt(length - 1);
                            return c != '}' ? -1 : RegExpCharImpl.parseNumber(s, idx + 2, 16);
                        }
                        if (length == 3) {
                            return RegExpCharImpl.parseNumber(s, idx + 1, 16);
                        }
                        return length == 4 ? RegExpCharImpl.parseNumber(s, idx + 1, 16) : -1;
                    }
                    case 'u': {
                        if (length <= idx + 1) {
                            return -1;
                        }
                        if (length > idx + 1 && s.charAt(idx + 1) == '{') {
                            char c = s.charAt(length - 1);
                            return c != '}' ? -1 : RegExpCharImpl.parseNumber(s, idx + 2, 16);
                        }
                        if (length != 6) {
                            return ch;
                        }
                        return RegExpCharImpl.parseNumber(s, idx + 1, 16);
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        return RegExpCharImpl.parseNumber(s, idx, 8);
                    }
                }
                return ch;
            }
            escaped = true;
        }
        return -1;
    }

    private static int parseNumber(String s, int offset, int radix) {
        int digit;
        int i;
        int sum = 0;
        for (i = offset; i < s.length() && (digit = Character.digit(s.charAt(i), radix)) >= 0; ++i) {
            if ((sum = sum * radix + digit) <= 0x10FFFF) continue;
            return -1;
        }
        if (i - offset <= 0) {
            return -1;
        }
        return sum;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpChar(this);
    }
}

