/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpProperty;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegExpPropertyImpl
extends RegExpElementImpl
implements RegExpProperty {
    private static final String[] UNICODE_BLOCKS;

    public RegExpPropertyImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    public PsiReference getReference() {
        ASTNode lbrace = this.getNode().findChildByType(RegExpTT.LBRACE);
        if (lbrace == null) {
            return null;
        }
        return new MyPsiReference();
    }

    @Override
    public boolean isNegated() {
        ASTNode node1 = this.getNode().findChildByType(RegExpTT.PROPERTY);
        ASTNode node2 = this.getNode().findChildByType(RegExpTT.CARET);
        return (node1 != null && node1.textContains('P')) ^ node2 != null;
    }

    @Override
    @Nullable
    public ASTNode getCategoryNode() {
        return this.getNode().findChildByType(RegExpTT.NAME);
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpProperty(this);
    }

    static {
        Field[] fields = Character.UnicodeBlock.class.getFields();
        ArrayList<String> unicodeBlocks = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            if (!field.getType().equals(Character.UnicodeBlock.class) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
            unicodeBlocks.add("In" + field.getName());
        }
        UNICODE_BLOCKS = ArrayUtil.toStringArray(unicodeBlocks);
    }

    private class MyPsiReference
    implements PsiReference {
        private MyPsiReference() {
        }

        public PsiElement getElement() {
            return RegExpPropertyImpl.this;
        }

        public TextRange getRangeInElement() {
            ASTNode firstNode = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.CARET);
            if (firstNode == null) {
                firstNode = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.LBRACE);
            }
            assert (firstNode != null);
            ASTNode rbrace = RegExpPropertyImpl.this.getNode().findChildByType(RegExpTT.RBRACE);
            int to = rbrace == null ? RegExpPropertyImpl.this.getTextRange().getEndOffset() : rbrace.getTextRange().getEndOffset() - 1;
            TextRange t = new TextRange(firstNode.getStartOffset() + 1, to);
            return t.shiftRight(-RegExpPropertyImpl.this.getTextRange().getStartOffset());
        }

        @Nullable
        public PsiElement resolve() {
            return RegExpPropertyImpl.this;
        }

        @NotNull
        public String getCanonicalText() {
            return this.getRangeInElement().substring(this.getElement().getText());
        }

        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            throw new IncorrectOperationException();
        }

        public boolean isReferenceTo(PsiElement element) {
            return false;
        }

        @NotNull
        public Object[] getVariants() {
            ASTNode categoryNode = RegExpPropertyImpl.this.getCategoryNode();
            if (categoryNode != null && categoryNode.getText().startsWith("In") && !categoryNode.getText().startsWith("Intelli")) {
                return UNICODE_BLOCKS;
            }
            boolean startsWithIs = categoryNode != null && categoryNode.getText().startsWith("Is");
            ArrayList result2 = ContainerUtil.newArrayList();
            for (Object[] objectArray : RegExpLanguageHosts.getInstance().getAllKnownProperties(this.getElement())) {
                String name = (String)ArrayUtil.getFirstElement((Object[])objectArray);
                if (name == null) continue;
                Object typeText = objectArray.length > 1 ? objectArray[1] : "Character.is" + name.substring("java".length()) + "()";
                result2.add(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)name).withPresentableText(startsWithIs ? "Is" + name : name).withIcon(PlatformIcons.PROPERTY_ICON).withTypeText((String)typeText), (double)this.getPriority(name)));
            }
            return ArrayUtil.toObjectArray((Collection)result2);
        }

        private int getPriority(@NotNull String propertyName) {
            if (propertyName.equals("all")) {
                return 3;
            }
            if (propertyName.startsWith("java")) {
                return 1;
            }
            if (propertyName.length() > 2) {
                return 2;
            }
            return 0;
        }

        public boolean isSoft() {
            return true;
        }
    }
}

