/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.lexer.CompactSyntaxLexerAdapter;
import org.jetbrains.annotations.NotNull;

public class RncHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> ourMap1 = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new CompactSyntaxLexerAdapter();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        return RncHighlighter.pack((TextAttributesKey)ourMap1.get(tokenType));
    }

    static {
        RncHighlighter.fillMap(ourMap1, (TokenSet)RncTokenTypes.KEYWORDS, (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        RncHighlighter.fillMap(ourMap1, (TokenSet)RncTokenTypes.OPERATORS, (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        RncHighlighter.fillMap(ourMap1, (TokenSet)RncTokenTypes.STRINGS, (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        ourMap1.put(RncTokenTypes.LBRACE, DefaultLanguageHighlighterColors.BRACES);
        ourMap1.put(RncTokenTypes.RBRACE, DefaultLanguageHighlighterColors.BRACES);
        ourMap1.put(RncTokenTypes.LBRACKET, DefaultLanguageHighlighterColors.BRACKETS);
        ourMap1.put(RncTokenTypes.RBRACKET, DefaultLanguageHighlighterColors.BRACKETS);
        ourMap1.put(RncTokenTypes.LPAREN, DefaultLanguageHighlighterColors.PARENTHESES);
        ourMap1.put(RncTokenTypes.RPAREN, DefaultLanguageHighlighterColors.PARENTHESES);
        ourMap1.put(RncTokenTypes.COMMA, DefaultLanguageHighlighterColors.COMMA);
        RncHighlighter.fillMap(ourMap1, (TokenSet)RncTokenTypes.DOC_TOKENS, (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
        RncHighlighter.fillMap(ourMap1, (TokenSet)RncTokenTypes.COMMENTS, (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        RncHighlighter.fillMap(ourMap1, (TokenSet)RncTokenTypes.IDENTIFIERS, (TextAttributesKey)DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        ourMap1.put(RncTokenTypes.ILLEGAL_CHAR, HighlighterColors.BAD_CHARACTER);
    }
}

