/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectProcedure;
import java.lang.reflect.Field;
import java.util.Locale;
import org.intellij.plugins.relaxNG.compact.RncElementType;
import org.intellij.plugins.relaxNG.compact.RngCompactLanguage;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.rngom.parse.compact.CompactSyntaxConstants;

public class RncTokenTypes {
    private static final TIntObjectHashMap<IElementType> ourTokenTypes = new TIntObjectHashMap();
    private static final IElementType WS;
    public static final TokenSet WHITESPACE;
    public static final IElementType ILLEGAL_CHAR;
    public static final IElementType LBRACE;
    public static final IElementType RBRACE;
    public static final IElementType LBRACKET;
    public static final IElementType RBRACKET;
    public static final IElementType LPAREN;
    public static final IElementType RPAREN;
    public static final IElementType GTGT;
    public static final TokenSet BRACES;
    public static final IElementType EQ;
    public static final IElementType PLUS;
    public static final IElementType MINUS;
    public static final IElementType STAR;
    public static final IElementType AND;
    public static final IElementType PIPE;
    public static final IElementType QUEST;
    public static final IElementType PREFIXED_NAME;
    public static final IElementType PREFIXED_STAR;
    public static final IElementType CHOICE_EQ;
    public static final IElementType INTERLEAVE_EQ;
    public static final IElementType COMMA;
    public static final TokenSet BINARY_OPS;
    public static final TokenSet QUANTIFIER_OPS;
    public static final IElementType DOC;
    public static final TokenSet DOC_TOKENS;
    public static final IElementType COMMENT;
    public static final TokenSet COMMENTS;
    public static final IElementType ESCAPED_IDENTIFIER;
    public static final TokenSet IDENTIFIERS;
    public static final TokenSet OPERATORS;
    public static final IElementType LITERAL;
    public static final TokenSet STRINGS;
    static final TokenSet READABLE_TEXT;
    public static final IElementType KEYWORD_ElEMENT;
    public static final IElementType KEYWORD_ATTRIBUTE;
    public static final IElementType KEYWORD_NAMESPACE;
    public static final IElementType KEYWORD_LIST;
    public static final IElementType KEYWORD_MIXED;
    public static final IElementType KEYWORD_EMPTY;
    public static final IElementType KEYWORD_GRAMMAR;
    public static final IElementType KEYWORD_TEXT;
    public static final IElementType KEYWORD_PARENT;
    public static final IElementType KEYWORD_EXTERNAL;
    public static final IElementType KEYWORD_NOT_ALLOWED;
    public static final IElementType KEYWORD_START;
    public static final IElementType KEYWORD_INCLUDE;
    public static final IElementType KEYWORD_DEFAULT;
    public static final IElementType KEYWORD_INHERIT;
    public static final IElementType KEYWORD_STRING;
    public static final IElementType KEYWORD_TOKEN;
    public static final IElementType KEYWORD_DATATYPES;
    public static final IElementType KEYWORD_DIV;
    public static final TokenSet KEYWORDS;
    public static final TokenSet IDENTIFIER_OR_KEYWORD;

    @NotNull
    public static IElementType get(int i2) {
        assert (!ourTokenTypes.isEmpty());
        IElementType type2 = (IElementType)ourTokenTypes.get(i2);
        assert (type2 != null) : "Unknown token kind: " + i2;
        return type2;
    }

    @NotNull
    private static IElementType get(final String name) {
        assert (!ourTokenTypes.isEmpty());
        final Ref ref = new Ref();
        ourTokenTypes.forEachValue((TObjectProcedure)new TObjectProcedure<IElementType>(){

            public boolean execute(IElementType iElementType) {
                if (iElementType.toString().equals(name)) {
                    ref.set((Object)iElementType);
                    return false;
                }
                return true;
            }
        });
        return (IElementType)ref.get();
    }

    static {
        assert (RngCompactLanguage.INSTANCE != null);
        try {
            Field field;
            String name;
            Field[] fields;
            Field[] fieldArray = fields = CompactSyntaxConstants.class.getFields();
            int n = fieldArray.length;
            for (int j = 0; j < n && !(name = (field = fieldArray[j]).getName()).equals("DEFAULT"); ++j) {
                if (!Integer.TYPE.isAssignableFrom(field.getType())) continue;
                Integer i2 = (Integer)field.get(null);
                ourTokenTypes.put(i2.intValue(), (Object)new RncElementType(name));
            }
            String[] tokens = CompactSyntaxConstants.tokenImage;
            for (int i3 = 0; i3 < tokens.length; ++i3) {
                String token = tokens[i3];
                if (token.matches("\"\\w*\"")) {
                    token = "KEYWORD_" + token.substring(1, token.length() - 1).toUpperCase(Locale.US);
                } else if (token.matches("\".*\"")) {
                    token = token.substring(1, token.length() - 1);
                }
                if (ourTokenTypes.get(i3) != null) continue;
                ourTokenTypes.put(i3, (Object)new RncElementType(token));
            }
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
        WS = RncTokenTypes.get(39);
        WHITESPACE = TokenSet.create((IElementType[])new IElementType[]{WS});
        ILLEGAL_CHAR = RncTokenTypes.get(60);
        LBRACE = RncTokenTypes.get("{");
        RBRACE = RncTokenTypes.get("}");
        LBRACKET = RncTokenTypes.get("[");
        RBRACKET = RncTokenTypes.get("]");
        LPAREN = RncTokenTypes.get("(");
        RPAREN = RncTokenTypes.get(")");
        GTGT = RncTokenTypes.get(59);
        BRACES = TokenSet.create((IElementType[])new IElementType[]{LBRACE, RBRACE});
        EQ = RncTokenTypes.get("=");
        PLUS = RncTokenTypes.get("+");
        MINUS = RncTokenTypes.get("-");
        STAR = RncTokenTypes.get("*");
        AND = RncTokenTypes.get("&");
        PIPE = RncTokenTypes.get("|");
        QUEST = RncTokenTypes.get("?");
        PREFIXED_NAME = RncTokenTypes.get(57);
        PREFIXED_STAR = RncTokenTypes.get(56);
        CHOICE_EQ = RncTokenTypes.get("|=");
        INTERLEAVE_EQ = RncTokenTypes.get("&=");
        COMMA = RncTokenTypes.get(",");
        BINARY_OPS = TokenSet.create((IElementType[])new IElementType[]{COMMA, PIPE, AND});
        QUANTIFIER_OPS = TokenSet.create((IElementType[])new IElementType[]{PLUS, STAR, QUEST});
        DOC = RncTokenTypes.get(40);
        DOC_TOKENS = TokenSet.create((IElementType[])new IElementType[]{DOC, RncTokenTypes.get(43), RncTokenTypes.get(41)});
        COMMENT = RncTokenTypes.get(42);
        COMMENTS = TokenSet.create((IElementType[])new IElementType[]{COMMENT, RncTokenTypes.get(44)});
        ESCAPED_IDENTIFIER = RncTokenTypes.get(55);
        IDENTIFIERS = TokenSet.create((IElementType[])new IElementType[]{RncTokenTypes.get(54), ESCAPED_IDENTIFIER});
        OPERATORS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{CHOICE_EQ, INTERLEAVE_EQ}), BINARY_OPS, QUANTIFIER_OPS});
        LITERAL = RncTokenTypes.get(58);
        STRINGS = TokenSet.create((IElementType[])new IElementType[]{LITERAL});
        READABLE_TEXT = TokenSet.orSet((TokenSet[])new TokenSet[]{DOC_TOKENS, COMMENTS, TokenSet.create((IElementType[])new IElementType[]{LITERAL})});
        KEYWORD_ElEMENT = RncTokenTypes.get("KEYWORD_ELEMENT");
        KEYWORD_ATTRIBUTE = RncTokenTypes.get("KEYWORD_ATTRIBUTE");
        KEYWORD_NAMESPACE = RncTokenTypes.get("KEYWORD_NAMESPACE");
        KEYWORD_LIST = RncTokenTypes.get("KEYWORD_LIST");
        KEYWORD_MIXED = RncTokenTypes.get("KEYWORD_MIXED");
        KEYWORD_EMPTY = RncTokenTypes.get("KEYWORD_EMPTY");
        KEYWORD_GRAMMAR = RncTokenTypes.get("KEYWORD_GRAMMAR");
        KEYWORD_TEXT = RncTokenTypes.get("KEYWORD_TEXT");
        KEYWORD_PARENT = RncTokenTypes.get("KEYWORD_PARENT");
        KEYWORD_EXTERNAL = RncTokenTypes.get("KEYWORD_EXTERNAL");
        KEYWORD_NOT_ALLOWED = RncTokenTypes.get("KEYWORD_NOTALLOWED");
        KEYWORD_START = RncTokenTypes.get("KEYWORD_START");
        KEYWORD_INCLUDE = RncTokenTypes.get("KEYWORD_INCLUDE");
        KEYWORD_DEFAULT = RncTokenTypes.get("KEYWORD_DEFAULT");
        KEYWORD_INHERIT = RncTokenTypes.get("KEYWORD_INHERIT");
        KEYWORD_STRING = RncTokenTypes.get("KEYWORD_STRING");
        KEYWORD_TOKEN = RncTokenTypes.get("KEYWORD_TOKEN");
        KEYWORD_DATATYPES = RncTokenTypes.get("KEYWORD_DATATYPES");
        KEYWORD_DIV = RncTokenTypes.get("KEYWORD_DIV");
        KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{KEYWORD_ATTRIBUTE, KEYWORD_DATATYPES, KEYWORD_DEFAULT, KEYWORD_DIV, KEYWORD_ElEMENT, KEYWORD_EMPTY, KEYWORD_EXTERNAL, KEYWORD_GRAMMAR, KEYWORD_INCLUDE, KEYWORD_INHERIT, KEYWORD_LIST, KEYWORD_MIXED, KEYWORD_NAMESPACE, KEYWORD_NOT_ALLOWED, KEYWORD_PARENT, KEYWORD_START, KEYWORD_STRING, KEYWORD_TEXT, KEYWORD_TOKEN});
        IDENTIFIER_OR_KEYWORD = TokenSet.orSet((TokenSet[])new TokenSet[]{KEYWORDS, IDENTIFIERS});
    }
}

