/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.psi.impl;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import org.intellij.plugins.relaxNG.compact.RncFileType;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.intellij.plugins.relaxNG.compact.psi.RncPattern;
import org.intellij.plugins.relaxNG.compact.psi.RncRef;
import org.intellij.plugins.relaxNG.compact.psi.util.EscapeUtil;
import org.intellij.plugins.relaxNG.compact.psi.util.RenameUtil;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.resolve.DefinitionResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PatternReference
extends PsiReferenceBase.Poly<RncRef>
implements Function<Define, ResolveResult>,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    public PatternReference(RncRef ref) {
        super((PsiElement)ref);
    }

    public TextRange getRangeInElement() {
        ASTNode node = this.findNameNode();
        if (node == null) {
            return TextRange.from((int)0, (int)0);
        }
        int offset = ((RncRef)this.myElement).getTextOffset();
        return TextRange.from((int)(offset - ((RncRef)this.myElement).getTextRange().getStartOffset()), (int)node.getTextLength());
    }

    private ASTNode findNameNode() {
        ASTNode node = ((RncRef)this.myElement).getNode();
        assert (node != null);
        return node.findChildByType(RncTokenTypes.IDENTIFIERS);
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        return results.length == 1 ? results[0].getElement() : null;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        RncGrammar scope = this.getScope();
        if (scope == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        Set<Define> set2 = DefinitionResolver.resolve(scope, this.getCanonicalText());
        if (set2 == null || set2.size() == 0) {
            return ResolveResult.EMPTY_ARRAY;
        }
        return (ResolveResult[])ContainerUtil.map2Array(set2, ResolveResult.class, (Function)this);
    }

    public ResolveResult fun(Define rncDefine) {
        Object element = rncDefine.getPsiElement();
        return element != null ? new PsiElementResolveResult(element) : new ResolveResult(){

            @Nullable
            public PsiElement getElement() {
                return null;
            }

            public boolean isValidResult() {
                return false;
            }
        };
    }

    @Nullable
    protected RncGrammar getScope() {
        return (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, RncGrammar.class, (boolean)true, (Class[])new Class[]{PsiFile.class});
    }

    @NotNull
    public String getCanonicalText() {
        ASTNode node = this.findNameNode();
        return node != null ? EscapeUtil.unescapeText(node) : "";
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        ASTNode newNode = RenameUtil.createIdentifierNode(((RncRef)this.getElement()).getManager(), newElementName);
        ASTNode nameNode = this.findNameNode();
        nameNode.getTreeParent().replaceChild(nameNode, newNode);
        return this.getElement();
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Object[] getVariants() {
        RncGrammar scope = this.getScope();
        if (scope == null) {
            return ResolveResult.EMPTY_ARRAY;
        }
        Map<String, Set<Define>> map2 = DefinitionResolver.getAllVariants(scope);
        if (map2 == null || map2.size() == 0) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return ContainerUtil.mapNotNull(map2.values(), defines -> defines.size() == 0 ? null : ((Define)defines.iterator().next()).getPsiElement()).toArray();
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        return "Unresolved pattern reference ''{0}''";
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        if (this.getScope() != null) {
            return new LocalQuickFix[]{new CreatePatternFix(this)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    static class CreatePatternFix
    implements LocalQuickFix {
        private final PatternReference myReference;

        public CreatePatternFix(PatternReference reference) {
            this.myReference = reference;
        }

        @NotNull
        public String getName() {
            return "Create Pattern '" + this.myReference.getCanonicalText() + "'";
        }

        @NotNull
        public String getFamilyName() {
            return "Create Pattern";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            RncFile rncfile = (RncFile)PsiFileFactory.getInstance((Project)((RncRef)this.myReference.getElement()).getProject()).createFileFromText("dummy.rnc", RncFileType.getInstance(), (CharSequence)"dummy = xxx");
            RncGrammar grammar = rncfile.getGrammar();
            assert (grammar != null);
            RncDefine def = (RncDefine)grammar.getFirstChild();
            RncGrammar scope = this.myReference.getScope();
            assert (scope != null);
            assert (def != null);
            RncDefine e = (RncDefine)scope.add(def);
            def.setName(this.myReference.getCanonicalText());
            SmartPsiElementPointer p = SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)e);
            ASTNode blockNode = e.getParent().getNode();
            assert (blockNode != null);
            ASTNode newNode = e.getNode();
            assert (newNode != null);
            CodeStyleManager.getInstance((Project)e.getManager().getProject()).reformatNewlyAddedElement(blockNode, newNode);
            RncDefine d = (RncDefine)p.getElement();
            assert (d != null);
            RncPattern definition = d.getPattern();
            assert (definition != null);
            int offset = definition.getTextRange().getStartOffset();
            definition.delete();
            VirtualFile virtualFile = ((RncRef)this.myReference.getElement()).getContainingFile().getVirtualFile();
            if (virtualFile != null) {
                FileEditorManager.getInstance((Project)project2).openTextEditor(new OpenFileDescriptor(project2, virtualFile, offset), true);
            }
        }
    }
}

