/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.inspections;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.plugins.relaxNG.compact.psi.RncDefine;
import org.intellij.plugins.relaxNG.compact.psi.RncElement;
import org.intellij.plugins.relaxNG.compact.psi.RncElementVisitor;
import org.intellij.plugins.relaxNG.compact.psi.RncFile;
import org.intellij.plugins.relaxNG.compact.psi.RncGrammar;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends XmlSuppressableInspectionTool {
    @Nls
    @NotNull
    public final String getGroupDisplayName() {
        return BaseInspection.getRngGroupDisplayName();
    }

    public static String getRngGroupDisplayName() {
        return "RELAX NG";
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element.getContainingFile() instanceof RncFile) {
            RncDefine define = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)element, RncDefine.class, (boolean)false);
            if (define != null && this.isSuppressedAt(define)) {
                return true;
            }
            RncGrammar grammar = (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)define, RncGrammar.class);
            return grammar != null && this.isSuppressedAt(grammar);
        }
        return super.isSuppressedFor(element);
    }

    private boolean isSuppressedAt(RncElement location) {
        PsiElement prev = location.getPrevSibling();
        while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
            String text;
            if (prev instanceof PsiComment && (text = prev.getText()).matches("\n*#\\s*suppress\\s.+") && (text.contains(this.getID()) || "ALL".equals(text))) {
                return true;
            }
            prev = prev.getPrevSibling();
        }
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        if (element.getContainingFile() instanceof RncFile) {
            return (SuppressQuickFix[])ArrayUtil.mergeArrays((Object[])new SuppressQuickFix[]{new SuppressAction("Define"){

                @Override
                protected PsiElement getTarget(PsiElement element) {
                    return PsiTreeUtil.getParentOfType((PsiElement)element, RncDefine.class, (boolean)false);
                }
            }, new SuppressAction("Grammar"){

                @Override
                protected PsiElement getTarget(PsiElement element) {
                    RncDefine define = (RncDefine)PsiTreeUtil.getParentOfType((PsiElement)element, RncDefine.class, (boolean)false);
                    RncGrammar target = define != null ? (RncGrammar)PsiTreeUtil.getParentOfType((PsiElement)define, RncGrammar.class, (boolean)false) : null;
                    return target != null && target.getText().startsWith("grammar ") ? target : null;
                }
            }}, (Object[])this.getXmlOnlySuppressions(element));
        }
        return super.getBatchSuppressActions(element);
    }

    private SuppressQuickFix[] getXmlOnlySuppressions(PsiElement element) {
        return (SuppressQuickFix[])ContainerUtil.map((Object[])super.getBatchSuppressActions(element), action -> new SuppressQuickFix((SuppressQuickFix)action){
            final /* synthetic */ SuppressQuickFix val$action;
            {
                this.val$action = suppressQuickFix;
            }

            @NotNull
            public String getName() {
                return this.val$action.getName();
            }

            public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
                return context.isValid();
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                PsiFile file2;
                PsiElement element1 = descriptor.getPsiElement();
                PsiFile psiFile = file2 = element1 == null ? null : element1.getContainingFile();
                if (file2 == null || file2.getFileType() != StdFileTypes.XML) {
                    return;
                }
                this.val$action.applyFix(project2, (CommonProblemDescriptor)descriptor);
            }

            @NotNull
            public String getFamilyName() {
                return this.val$action.getFamilyName();
            }

            public boolean isSuppressAll() {
                return this.val$action.isSuppressAll();
            }
        }, (Object[])SuppressQuickFix.EMPTY_ARRAY);
    }

    private void suppress(PsiFile file2, @NotNull PsiElement location) {
        BaseInspection.suppress(file2, location, "#suppress " + this.getID(), (Function<String, String>)((Function)text -> text + ", " + this.getID()));
    }

    private static void suppress(PsiFile file2, @NotNull PsiElement location, String suppressComment, Function<String, String> replace) {
        Project project2 = file2.getProject();
        VirtualFile vfile = file2.getVirtualFile();
        if (vfile == null || ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(new VirtualFile[]{vfile}).hasReadonlyFiles()) {
            return;
        }
        Document doc = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        assert (doc != null);
        PsiElement leaf = location.getPrevSibling();
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getPrevSibling();
        }
        while (leaf instanceof PsiComment || leaf instanceof PsiWhiteSpace) {
            String text = leaf.getText();
            if (text.matches("\n*#\\s*suppress\\s.+")) {
                TextRange textRange = leaf.getTextRange();
                doc.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)replace.fun((Object)text));
                return;
            }
            leaf = leaf.getPrevSibling();
        }
        int offset = location.getTextRange().getStartOffset();
        doc.insertString(offset, (CharSequence)(suppressComment + "\n"));
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(doc, offset + suppressComment.length());
    }

    @NotNull
    public abstract RncElementVisitor buildVisitor(@NotNull ProblemsHolder var1, boolean var2);

    private abstract class SuppressAction
    implements SuppressQuickFix {
        private final String myLocation;

        public SuppressAction(String location) {
            this.myLocation = location;
        }

        @NotNull
        public String getName() {
            return "Suppress for " + this.myLocation;
        }

        @NotNull
        public String getFamilyName() {
            return BaseInspection.this.getDisplayName();
        }

        public boolean isAvailable(@NotNull Project project2, @NotNull PsiElement context) {
            return context.isValid();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement target = this.getTarget(element);
            if (target == null) {
                return;
            }
            BaseInspection.this.suppress(element.getContainingFile(), target);
        }

        protected abstract PsiElement getTarget(PsiElement var1);

        public boolean isSuppressAll() {
            return false;
        }
    }
}

