/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.ui.PortField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;

class BuiltInServerConfigurableUi
implements ConfigurableUi<BuiltInServerOptions> {
    private JPanel mainPanel;
    private PortField builtInServerPort;
    private JCheckBox builtInServerAvailableExternallyCheckBox;
    private JCheckBox allowUnsignedRequestsCheckBox;

    public BuiltInServerConfigurableUi() {
        this.$$$setupUI$$$();
        this.builtInServerPort.setMin(1024);
    }

    @NotNull
    public JComponent getComponent() {
        return this.mainPanel;
    }

    public boolean isModified(@NotNull BuiltInServerOptions settings) {
        return this.builtInServerPort.getNumber() != settings.builtInServerPort || this.builtInServerAvailableExternallyCheckBox.isSelected() != settings.builtInServerAvailableExternally || this.allowUnsignedRequestsCheckBox.isSelected() != settings.allowUnsignedRequests;
    }

    public void apply(@NotNull BuiltInServerOptions settings) {
        boolean builtInServerPortChanged = settings.builtInServerPort != this.builtInServerPort.getNumber() || settings.builtInServerAvailableExternally != this.builtInServerAvailableExternallyCheckBox.isSelected();
        settings.allowUnsignedRequests = this.allowUnsignedRequestsCheckBox.isSelected();
        if (builtInServerPortChanged) {
            settings.builtInServerPort = this.builtInServerPort.getNumber();
            settings.builtInServerAvailableExternally = this.builtInServerAvailableExternallyCheckBox.isSelected();
            BuiltInServerOptions.onBuiltInServerPortChanged();
        }
    }

    public void reset(@NotNull BuiltInServerOptions settings) {
        this.builtInServerPort.setNumber(settings.builtInServerPort);
        this.builtInServerAvailableExternallyCheckBox.setSelected(settings.builtInServerAvailableExternally);
        this.allowUnsignedRequestsCheckBox.setSelected(settings.allowUnsignedRequests);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        PortField portField;
        JPanel jPanel;
        this.mainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.builtInServerPort = portField = new PortField();
        jPanel.add((Component)portField, new GridConstraints(0, 1, 1, 1, 8, 1, 0, 0, null, null, null));
        this.builtInServerAvailableExternallyCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/XmlBundle").getString("setting.value.can.accept.external.connections"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/XmlBundle").getString("setting.value.builtin.server.port.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 2, 1, 6, null, null, null));
        this.allowUnsignedRequestsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/XmlBundle").getString("setting.value.builtin.server.allow.unsigned.requests"));
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

