/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BuiltinWebServerAccess;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a2\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u0001H\u0007\u00a8\u0006\f"}, d2={"compareAuthority", "", "currentAuthority", "", "getBuiltInServerUrls", "", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "appendAccessToken", "built-in-server"})
public final class BuiltInWebBrowserUrlProviderKt {
    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable String currentAuthority, boolean appendAccessToken) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if (currentAuthority != null && !BuiltInWebBrowserUrlProviderKt.compareAuthority((String)currentAuthority)) {
            return CollectionsKt.emptyList();
        }
        String string = WebServerPathToFileManager.Companion.getInstance(project2).getPath(file2);
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String path = string;
        int effectiveBuiltInServerPort = BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort();
        String userToken = null;
        try {
            userToken = BuiltinWebServerAccess.getUserAuthenticationToken();
        }
        catch (IOException e) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = "Unable to get User authentication token for launching path '%s'";
            Object[] objectArray = new Object[]{path};
            Logger logger = BuiltInWebServerKt.getLOG();
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            String string4 = string3;
            logger.warn(string4, (Throwable)e);
            return CollectionsKt.emptyList();
        }
        Url[] urlArray = currentAuthority;
        if (currentAuthority == null) {
            urlArray = "localhost:" + effectiveBuiltInServerPort;
        }
        char c = '/';
        Url[] urlArray2 = new StringBuilder();
        Url[] urlArray3 = urlArray;
        String string5 = String.valueOf(c) + userToken;
        Url url = Urls.newHttpUrl((String)urlArray3, urlArray2.append(string5).append('/').append(project2.getName()).append('/').append(path).toString());
        int defaultPort = BuiltInServerManager.getInstance().getPort();
        if (currentAuthority != null || defaultPort == effectiveBuiltInServerPort) {
            return CollectionsKt.listOf((Object)url);
        }
        Url[] urlArray4 = new Url[2];
        urlArray4[0] = url;
        Url[] urlArray5 = currentAuthority;
        if (currentAuthority == null) {
            urlArray5 = "localhost:" + defaultPort;
        }
        char c2 = '/';
        StringBuilder stringBuilder = new StringBuilder();
        Url[] urlArray6 = urlArray5;
        int n = 1;
        urlArray2 = urlArray4;
        urlArray3 = urlArray4;
        String string6 = String.valueOf(c2) + userToken;
        urlArray2[n] = Urls.newHttpUrl((String)urlArray6, stringBuilder.append(string6).append('/').append(project2.getName()).append('/').append(path).toString());
        List<Url> list = Arrays.asList(urlArray3);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(url, Urls.\u2026oject.name + '/' + path))");
        return list;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ List getBuiltInServerUrls$default(VirtualFile virtualFile, Project project2, String string, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls(virtualFile, project2, string, bl);
    }

    @JvmOverloads
    @NotNull
    public static final List<Url> getBuiltInServerUrls(@NotNull VirtualFile file2, @NotNull Project project2, @Nullable String currentAuthority) {
        return BuiltInWebBrowserUrlProviderKt.getBuiltInServerUrls$default(file2, project2, currentAuthority, false, 8, null);
    }

    public static final boolean compareAuthority(@Nullable String currentAuthority) {
        int portIndex;
        CharSequence charSequence = currentAuthority;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        String string = currentAuthority;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        if ((portIndex = StringsKt.indexOf$default((CharSequence)string, (char)':', (int)0, (boolean)false, (int)6, null)) < 0) {
            return false;
        }
        String string2 = currentAuthority;
        int n = 0;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n, portIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String host = string4;
        if (!BuiltInWebServerKt.isOwnHostName(host)) {
            return false;
        }
        String string5 = currentAuthority;
        int n2 = portIndex + 1;
        String string6 = string5;
        if (string6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string7 = string6.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        int port = StringUtil.parseInt((String)string7, (int)-1);
        return port == BuiltInServerOptions.getInstance().getEffectiveBuiltInServerPort() || port == BuiltInServerManager.getInstance().getPort();
    }
}

