/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.PathQuery;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"EMPTY_PATH_RESOLVER", "Lorg/jetbrains/builtInWebServer/FileResolver;", "RELATIVE_PATH_RESOLVER", "cacheSize", "", "defaultPathQuery", "Lorg/jetbrains/builtInWebServer/PathQuery;", "getDefaultPathQuery", "()Lorg/jetbrains/builtInWebServer/PathQuery;", "built-in-server"})
public final class WebServerPathToFileManagerKt {
    private static final long cacheSize = 16384L;
    private static final FileResolver RELATIVE_PATH_RESOLVER;
    private static final FileResolver EMPTY_PATH_RESOLVER;
    @NotNull
    private static final PathQuery defaultPathQuery;

    @NotNull
    public static final PathQuery getDefaultPathQuery() {
        return defaultPathQuery;
    }

    static {
        cacheSize = 16384L;
        RELATIVE_PATH_RESOLVER = new FileResolver(){

            @Nullable
            public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary, @NotNull PathQuery pathQuery) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
                if (pathQuery.getUseVfs() || Intrinsics.areEqual((Object)root.getFileSystem(), (Object)LocalFileSystem.getInstance()) ^ true || Intrinsics.areEqual((Object)path, (Object)".htaccess") || Intrinsics.areEqual((Object)path, (Object)"config.json")) {
                    PathInfo pathInfo;
                    VirtualFile virtualFile = root.findFileByRelativePath(path);
                    if (virtualFile != null) {
                        VirtualFile virtualFile2;
                        VirtualFile it = virtualFile2 = virtualFile;
                        pathInfo = new PathInfo(null, it, root, moduleName, isLibrary, false, 32, null);
                    } else {
                        pathInfo = null;
                    }
                    return pathInfo;
                }
                Path file2 = Paths.get(root.getPath(), path);
                return PathKt.exists((Path)file2) ? new PathInfo(file2, null, root, moduleName, isLibrary, false, 32, null) : null;
            }
        };
        EMPTY_PATH_RESOLVER = new FileResolver(){

            @Nullable
            public PathInfo resolve(@NotNull String path, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary, @NotNull PathQuery pathQuery) {
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                Intrinsics.checkParameterIsNotNull((Object)pathQuery, (String)"pathQuery");
                VirtualFile virtualFile = BuiltInWebServerKt.findIndexFile(root);
                if (virtualFile == null) {
                    return null;
                }
                VirtualFile file2 = virtualFile;
                return new PathInfo(null, file2, root, moduleName, isLibrary, false, 32, null);
            }
        };
        defaultPathQuery = new PathQuery(false, false, false, false, 15, null);
    }

    @NotNull
    public static final /* synthetic */ FileResolver access$getEMPTY_PATH_RESOLVER$p() {
        return EMPTY_PATH_RESOLVER;
    }

    @NotNull
    public static final /* synthetic */ FileResolver access$getRELATIVE_PATH_RESOLVER$p() {
        return RELATIVE_PATH_RESOLVER;
    }

    public static final /* synthetic */ long access$getCacheSize$p() {
        return cacheSize;
    }
}

