/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer.ssi;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import com.google.common.net.PercentEscaper;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.ssi.SsiExternalResolver;
import org.jetbrains.builtInWebServer.ssi.Strftime;

public class SsiProcessingState {
    protected static final String DEFAULT_CONFIG_ERR_MSG = "[an error occurred while processing this directive]";
    protected static final String DEFAULT_CONFIG_TIME_FMT = "%A, %d-%b-%Y %T %Z";
    protected static final String DEFAULT_CONFIG_SIZE_FMT = "abbrev";
    protected static final Escaper urlEscaper = new PercentEscaper(",:-_.*/!~'()", false);
    protected String configErrorMessage = "[an error occurred while processing this directive]";
    protected String configTimeFmt = "%A, %d-%b-%Y %T %Z";
    protected String configSizeFmt = "abbrev";
    protected final SsiExternalResolver ssiExternalResolver;
    protected final long lastModifiedDate;
    protected Strftime strftime;
    protected final SsiConditionalState conditionalState = new SsiConditionalState();
    private boolean alreadySet;

    public SsiProcessingState(@NotNull SsiExternalResolver ssiExternalResolver, long lastModifiedDate) {
        this.ssiExternalResolver = ssiExternalResolver;
        this.lastModifiedDate = lastModifiedDate;
        this.setConfigTimeFormat(DEFAULT_CONFIG_TIME_FMT, true);
    }

    public void setConfigTimeFormat(String configTimeFmt, boolean fromConstructor) {
        this.configTimeFmt = configTimeFmt;
        this.strftime = new Strftime(configTimeFmt, Locale.US);
        this.setDateVariables(fromConstructor);
    }

    public String getVariableValue(String variableName) {
        return this.getVariableValue(variableName, "none");
    }

    public String getVariableValue(@NotNull String variableName, String encoding) {
        String variableValue = this.ssiExternalResolver.getVariableValue(variableName);
        return variableValue == null ? null : this.encode(variableValue, encoding);
    }

    public String substituteVariables(String val) {
        int charEnd;
        if (val.indexOf(36) < 0 && val.indexOf(38) < 0) {
            return val;
        }
        val = val.replace("&lt;", "<");
        val = val.replace("&gt;", ">");
        val = val.replace("&quot;", "\"");
        val = val.replace("&amp;", "&");
        StringBuilder sb = new StringBuilder(val);
        int charStart = sb.indexOf("&#");
        while (charStart > -1 && (charEnd = sb.indexOf(";", charStart)) > -1) {
            char c = (char)Integer.parseInt(sb.substring(charStart + 2, charEnd));
            sb.delete(charStart, charEnd + 1);
            sb.insert(charStart, c);
            charStart = sb.indexOf("&#");
        }
        int i2 = 0;
        while (i2 < sb.length()) {
            String varName;
            String value2;
            while (i2 < sb.length()) {
                if (sb.charAt(i2) == '$') {
                    ++i2;
                    break;
                }
                ++i2;
            }
            if (i2 == sb.length()) break;
            if (i2 > 1 && sb.charAt(i2 - 2) == '\\') {
                sb.deleteCharAt(i2 - 2);
                --i2;
                continue;
            }
            int nameStart = i2;
            int start = i2 - 1;
            char endChar = ' ';
            if (sb.charAt(i2) == '{') {
                ++nameStart;
                endChar = '}';
            }
            while (i2 < sb.length() && sb.charAt(i2) != endChar) {
                ++i2;
            }
            int end = i2;
            int nameEnd = end++;
            if (endChar == '}') {
                // empty if block
            }
            if ((value2 = this.getVariableValue(varName = sb.substring(nameStart, nameEnd))) == null) {
                value2 = "";
            }
            sb.replace(start, end, value2);
            i2 = start + value2.length();
        }
        return sb.toString();
    }

    protected void setDateVariables(boolean fromConstructor) {
        if (fromConstructor && this.alreadySet) {
            return;
        }
        this.alreadySet = true;
        Date date = new Date();
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        this.ssiExternalResolver.setVariableValue("DATE_GMT", this.formatDate(date, timeZone));
        this.ssiExternalResolver.setVariableValue("DATE_LOCAL", this.formatDate(date, null));
        this.ssiExternalResolver.setVariableValue("LAST_MODIFIED", this.formatDate(new Date(this.lastModifiedDate), null));
    }

    @NotNull
    protected String formatDate(@NotNull Date date, @Nullable TimeZone timeZone) {
        if (timeZone == null) {
            return this.strftime.format(date);
        }
        TimeZone oldTimeZone = this.strftime.getTimeZone();
        this.strftime.setTimeZone(timeZone);
        String retVal = this.strftime.format(date);
        this.strftime.setTimeZone(oldTimeZone);
        return retVal;
    }

    @NotNull
    protected String encode(@NotNull String value2, @NotNull String encoding) {
        if (encoding.equalsIgnoreCase("url")) {
            return urlEscaper.escape(value2);
        }
        if (encoding.equalsIgnoreCase("none")) {
            return value2;
        }
        if (encoding.equalsIgnoreCase("entity")) {
            return HtmlEscapers.htmlEscaper().escape(value2);
        }
        throw new IllegalArgumentException("Unknown encoding: " + encoding);
    }

    static class SsiConditionalState {
        boolean branchTaken = false;
        int nestingCount = 0;
        boolean processConditionalCommandsOnly = false;

        SsiConditionalState() {
        }
    }
}

