/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Getter;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class AsyncValueLoader<T> {
    private final AtomicReference<Promise<T>> ref = new AtomicReference();
    private volatile long modificationCount;
    private volatile long loadedModificationCount;
    private final Consumer<T> doneHandler = new Consumer<T>(){

        public void consume(T o) {
            AsyncValueLoader.this.loadedModificationCount = AsyncValueLoader.this.modificationCount;
        }
    };

    @NotNull
    public final Promise<T> get() {
        return this.get(true);
    }

    public final T getResult() {
        return (T)((Getter)this.get(true)).get();
    }

    public final void reset() {
        Promise oldValue = this.ref.getAndSet(null);
        if (oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    private void rejectAndDispose(@NotNull AsyncPromise<T> asyncResult) {
        try {
            asyncResult.setError("rejected");
        }
        finally {
            Object result2 = asyncResult.get();
            if (result2 != null) {
                this.disposeResult(result2);
            }
        }
    }

    protected void disposeResult(@NotNull T result2) {
        if (result2 instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)result2), (boolean)false);
        }
    }

    public final boolean has() {
        Promise<T> result2 = this.ref.get();
        return result2 != null && result2.getState() == Promise.State.FULFILLED && ((Getter)result2).get() != null;
    }

    @NotNull
    public final Promise<T> get(boolean checkFreshness) {
        AsyncPromise promise2 = this.ref.get();
        if (promise2 == null) {
            promise2 = new AsyncPromise();
            if (!this.ref.compareAndSet((Promise<T>)null, (Promise<T>)promise2)) {
                return this.ref.get();
            }
        } else {
            Promise.State state = promise2.getState();
            if (state == Promise.State.PENDING) {
                return promise2;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(((Getter)promise2).get())) {
                    return promise2;
                }
                if (!this.ref.compareAndSet((Promise<T>)promise2, (Promise<T>)(promise2 = new AsyncPromise()))) {
                    Promise<T> valueFromAnotherThread = this.ref.get();
                    while (valueFromAnotherThread == null) {
                        if (this.ref.compareAndSet((Promise<T>)null, (Promise<T>)promise2)) {
                            return this.getPromise(promise2);
                        }
                        valueFromAnotherThread = this.ref.get();
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise(promise2);
    }

    protected boolean isCancelOnReject() {
        return false;
    }

    @NotNull
    private Promise<T> getPromise(@NotNull AsyncPromise<T> promise2) {
        Promise<T> effectivePromise;
        try {
            effectivePromise = this.load(promise2);
            if (effectivePromise != promise2) {
                this.ref.compareAndSet((Promise<T>)promise2, effectivePromise);
            }
        }
        catch (Throwable e) {
            this.ref.compareAndSet((Promise<T>)promise2, (Promise<T>)null);
            this.rejectAndDispose(promise2);
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        effectivePromise.done(this.doneHandler);
        if (this.isCancelOnReject()) {
            effectivePromise.rejected(throwable -> this.ref.compareAndSet(effectivePromise, null));
        }
        if (effectivePromise != promise2) {
            effectivePromise.notify(promise2);
        }
        return effectivePromise;
    }

    @NotNull
    protected abstract Promise<T> load(@NotNull AsyncPromise<T> var1) throws IOException;

    protected boolean isUpToDate(@Nullable T result2) {
        return this.loadedModificationCount == this.modificationCount;
    }

    public final void set(@NotNull T result2) {
        Promise oldValue = this.ref.getAndSet(Promise.resolve(result2));
        if (oldValue != null && oldValue instanceof AsyncPromise) {
            this.rejectAndDispose((AsyncPromise)oldValue);
        }
    }

    public final void markDirty() {
        ++this.modificationCount;
    }
}

