/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import com.intellij.openapi.util.Getter;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

public abstract class PromiseManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater;

    public PromiseManager(@NotNull AtomicFieldUpdater<HOST, Promise<VALUE>> fieldUpdater) {
        this.fieldUpdater = fieldUpdater;
    }

    public PromiseManager(@NotNull Class<HOST> ownerClass) {
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, Promise.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value2) {
        return true;
    }

    @NotNull
    public abstract Promise<VALUE> load(@NotNull HOST var1);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value2) {
        if (value2 == null) {
            this.reset(host);
        } else {
            ((AsyncPromise)this.getOrCreateAsyncResult(host, false, false)).setResult(value2);
        }
    }

    public final boolean has(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 != null && result2.getState() == Promise.State.FULFILLED;
    }

    @Nullable
    public final Promise.State getState(HOST host) {
        Promise result2 = (Promise)this.fieldUpdater.get(host);
        return result2 == null ? null : result2.getState();
    }

    @NotNull
    public final Promise<VALUE> get(HOST host) {
        return this.get(host, true);
    }

    @NotNull
    public final Promise<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    @NotNull
    private Promise<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load2) {
        Promise promise2 = (Promise)this.fieldUpdater.get(host);
        if (promise2 == null) {
            promise2 = new AsyncPromise();
            if (!this.fieldUpdater.compareAndSet(host, null, (Object)promise2)) {
                return (Promise)this.fieldUpdater.get(host);
            }
        } else {
            Promise.State state = promise2.getState();
            if (state == Promise.State.PENDING) {
                return promise2;
            }
            if (state == Promise.State.FULFILLED) {
                if (!checkFreshness || this.isUpToDate(host, ((Getter)promise2).get())) {
                    return promise2;
                }
                if (!this.fieldUpdater.compareAndSet(host, (Object)promise2, (Object)(promise2 = new AsyncPromise()))) {
                    Promise valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, (Object)promise2)) {
                            return this.getPromise(host, load2, promise2);
                        }
                        valueFromAnotherThread = (Promise)this.fieldUpdater.get(host);
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        return this.getPromise(host, load2, promise2);
    }

    @NotNull
    private Promise<VALUE> getPromise(HOST host, boolean load2, Promise<VALUE> promise2) {
        if (!load2 || promise2.getState() != Promise.State.PENDING) {
            return promise2;
        }
        Promise<VALUE> effectivePromise = this.load(host);
        if (effectivePromise != promise2) {
            this.fieldUpdater.compareAndSet(host, promise2, effectivePromise);
            effectivePromise.notify((AsyncPromise)promise2);
        }
        return effectivePromise;
    }
}

