/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;

public class CustomPropertiesValuePresentation
extends XValuePresentation {
    private final ObjectValue value;
    private final List<Variable> properties;

    public CustomPropertiesValuePresentation(@NotNull ObjectValue value2, @NotNull List<Variable> properties) {
        this.value = value2;
        this.properties = properties;
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        renderer.renderComment(VariableViewKt.getObjectValueDescription(this.value));
        renderer.renderSpecialSymbol(" {");
        boolean isFirst = true;
        block7: for (Variable property : this.properties) {
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(", ");
            }
            renderer.renderValue(property.getName());
            renderer.renderSpecialSymbol(": ");
            Value value2 = property.getValue();
            assert (value2 != null);
            switch (value2.getType()) {
                case BOOLEAN: 
                case NULL: 
                case UNDEFINED: 
                case SYMBOL: {
                    renderer.renderKeywordValue(value2.getValueString());
                    continue block7;
                }
                case NUMBER: {
                    renderer.renderNumericValue(value2.getValueString());
                    continue block7;
                }
                case STRING: {
                    String string = value2.getValueString();
                    renderer.renderStringValue(string, "\"\\", 1000);
                    int actualStringLength = value2 instanceof StringValue ? ((StringValue)value2).getLength() : string.length();
                    if (actualStringLength <= 1000) continue block7;
                    renderer.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])new Object[]{actualStringLength}));
                    continue block7;
                }
                case FUNCTION: {
                    renderer.renderComment(VariableViewKt.trimFunctionDescription(value2));
                    continue block7;
                }
                case OBJECT: {
                    renderer.renderComment(VariableViewKt.getObjectValueDescription((ObjectValue)value2));
                    continue block7;
                }
            }
            renderer.renderValue(value2.getValueString());
        }
        renderer.renderSpecialSymbol("}");
    }
}

