/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ParentlessVariableContext;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroup;
import org.jetbrains.debugger.ScopeVariablesGroupKt$WhenMappings;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableContextWrapper;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a \u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"createAndAddScopeList", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "scopes", "", "Lorg/jetbrains/debugger/Scope;", "context", "Lorg/jetbrains/debugger/VariableContext;", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "createVariableContext", "scope", "parentContext", "createScopeNodeName", "", "script-debugger-ui"})
public final class ScopeVariablesGroupKt {
    public static final void createAndAddScopeList(@NotNull XCompositeNode node, @NotNull List<? extends Scope> scopes, @NotNull VariableContext context, @Nullable CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        XValueChildrenList list = new XValueChildrenList(scopes.size());
        for (Scope scope : scopes) {
            list.addTopGroup((XValueGroup)new ScopeVariablesGroup(scope, context, callFrame));
        }
        node.addChildren(list, true);
    }

    @NotNull
    public static final VariableContext createVariableContext(@NotNull Scope scope, @NotNull VariableContext parentContext, @Nullable CallFrame callFrame) {
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)parentContext, (String)"parentContext");
        if (callFrame == null || Intrinsics.areEqual((Object)((Object)scope.getType()), (Object)((Object)Scope.Type.LIBRARY))) {
            return new ParentlessVariableContext(parentContext, scope, Intrinsics.areEqual((Object)((Object)scope.getType()), (Object)((Object)Scope.Type.GLOBAL)));
        }
        return new VariableContextWrapper(parentContext, scope);
    }

    private static final String createScopeNodeName(@NotNull Scope $receiver) {
        switch (ScopeVariablesGroupKt$WhenMappings.$EnumSwitchMapping$0[$receiver.getType().ordinal()]) {
            case 1: {
                String string = XDebuggerBundle.message((String)"scope.global", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.global\")");
                return string;
            }
            case 2: {
                String string = XDebuggerBundle.message((String)"scope.local", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.local\")");
                return string;
            }
            case 3: {
                String string = XDebuggerBundle.message((String)"scope.with", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.with\")");
                return string;
            }
            case 4: {
                String string = XDebuggerBundle.message((String)"scope.closure", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.closure\")");
                return string;
            }
            case 5: {
                String string = XDebuggerBundle.message((String)"scope.catch", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.catch\")");
                return string;
            }
            case 6: {
                String string = XDebuggerBundle.message((String)"scope.library", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.library\")");
                return string;
            }
            case 7: {
                String string = XDebuggerBundle.message((String)"scope.instance", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.instance\")");
                return string;
            }
            case 8: {
                String string = XDebuggerBundle.message((String)"scope.class", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.class\")");
                return string;
            }
            case 9: {
                String string = XDebuggerBundle.message((String)"scope.block", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.block\")");
                return string;
            }
            case 10: {
                String string = XDebuggerBundle.message((String)"scope.script", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.script\")");
                return string;
            }
            case 11: {
                String string = XDebuggerBundle.message((String)"scope.unknown", (Object[])new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"XDebuggerBundle.message(\"scope.unknown\")");
                return string;
            }
        }
        throw (Throwable)new IllegalArgumentException($receiver.getType().name());
    }

    @NotNull
    public static final /* synthetic */ String access$createScopeNodeName(@NotNull Scope $receiver) {
        return ScopeVariablesGroupKt.createScopeNodeName($receiver);
    }
}

