/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ValueManager;

public abstract class VariablesHost<VALUE_MANAGER extends ValueManager> {
    private static final PromiseManager<VariablesHost, List<Variable>> VARIABLES_LOADER = new PromiseManager<VariablesHost, List<Variable>>(VariablesHost.class){

        @Override
        public boolean isUpToDate(@NotNull VariablesHost host, @NotNull List<Variable> data) {
            return ((ValueManager)host.valueManager).getCacheStamp() == host.cacheStamp;
        }

        @Override
        @NotNull
        public Promise load(@NotNull VariablesHost host) {
            return ((ValueManager)host.valueManager).isObsolete() ? Promises.cancelledPromise() : host.load();
        }
    };
    private volatile Promise<List<Variable>> result;
    private volatile int cacheStamp = -1;
    public final VALUE_MANAGER valueManager;

    public VariablesHost(@NotNull VALUE_MANAGER manager) {
        this.valueManager = manager;
    }

    @NotNull
    public final Promise<List<Variable>> get() {
        return VARIABLES_LOADER.get(this);
    }

    @Nullable
    public final Promise.State getState() {
        return VARIABLES_LOADER.getState(this);
    }

    public final void set(@NotNull List<Variable> result2) {
        this.updateCacheStamp();
        VARIABLES_LOADER.set(this, result2);
    }

    @NotNull
    protected abstract Promise<List<Variable>> load();

    public final void updateCacheStamp() {
        this.cacheStamp = ((ValueManager)this.valueManager).getCacheStamp();
    }

    public Promise<?> clearCaches() {
        this.cacheStamp = -1;
        VARIABLES_LOADER.reset(this);
        return Promises.resolvedPromise();
    }
}

