/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.google.gson.stream.JsonReader;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.RestService;

final class DiffHttpService
extends RestService {
    DiffHttpService() {
    }

    @Override
    @NotNull
    protected String getServiceName() {
        return "diff";
    }

    @Override
    protected boolean isMethodSupported(@NotNull HttpMethod method2) {
        return method2 == HttpMethod.POST;
    }

    @Override
    @Nullable
    public String execute(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) throws IOException {
        ArrayList<DiffContent> contents = new ArrayList<DiffContent>();
        ArrayList<String> titles = new ArrayList<String>();
        boolean focused = true;
        String windowTitle = null;
        JsonReader reader = DiffHttpService.createJsonReader(request);
        if (reader.hasNext()) {
            String fileType = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("fileType")) {
                    fileType = reader.nextString();
                    continue;
                }
                if (name.equals("focused")) {
                    focused = reader.nextBoolean();
                    continue;
                }
                if (name.equals("windowTitle")) {
                    windowTitle = StringUtil.nullize((String)reader.nextString(), (boolean)true);
                    continue;
                }
                if (name.equals("contents")) {
                    String error = DiffHttpService.readContent(reader, contents, titles, fileType);
                    if (error == null) continue;
                    return error;
                }
                reader.skipValue();
            }
            reader.endObject();
        }
        if (contents.isEmpty()) {
            return "Empty request";
        }
        Project project2 = DiffHttpService.getLastFocusedOrOpenedProject();
        if (project2 == null) {
            project2 = ProjectManager.getInstance().getDefaultProject();
        }
        boolean finalFocused = focused;
        String finalWindowTitle = windowTitle;
        Project finalProject = project2;
        ApplicationManager.getApplication().invokeLater(() -> {
            if (finalFocused) {
                ProjectUtil.focusProjectWindow(finalProject, true);
            }
            DiffManager.getInstance().showDiff(finalProject, (DiffRequest)new SimpleDiffRequest(StringUtil.notNullize((String)finalWindowTitle, (String)"Diff Service"), contents, titles));
        }, project2.getDisposed());
        DiffHttpService.sendOk(request, context);
        return null;
    }

    @Nullable
    private static String readContent(@NotNull JsonReader reader, @NotNull List<DiffContent> contents, @NotNull List<String> titles, @Nullable String defaultFileTypeName) throws IOException {
        FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
        FileType defaultFileType = defaultFileTypeName == null ? null : fileTypeRegistry.findFileTypeByName(defaultFileTypeName);
        reader.beginArray();
        while (reader.hasNext()) {
            String title = null;
            String fileType = null;
            String content = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.nextName();
                if (name.equals("title")) {
                    title = reader.nextString();
                    continue;
                }
                if (name.equals("fileType")) {
                    fileType = reader.nextString();
                    continue;
                }
                if (name.equals("content")) {
                    content = reader.nextString();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            if (content == null) {
                return "content is not specified";
            }
            FileType type2 = fileType == null ? defaultFileType : fileTypeRegistry.findFileTypeByName(fileType);
            contents.add((DiffContent)DiffContentFactory.getInstance().create(content, type2));
            titles.add(StringUtil.isEmptyOrSpaces((String)title) ? "" : title);
        }
        reader.endArray();
        return null;
    }

    @Override
    public boolean isAccessible(@NotNull HttpRequest request) {
        return true;
    }
}

