/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

@ChannelHandler.Sharable
public final class ChannelRegistrar
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getInstance(ChannelRegistrar.class);
    private final AtomicReference<ServerChannel> serverChannel = new AtomicReference();
    private final Set<Channel> clientChannels = ContainerUtil.newConcurrentSet();
    private boolean isEventLoopGroupOwner;

    public boolean isEmpty() {
        return this.serverChannel.get() == null && this.clientChannels.isEmpty();
    }

    public void setServerChannel(@NotNull Channel channel, boolean isOwnEventLoopGroup) {
        boolean isSet = this.serverChannel.compareAndSet(null, (ServerChannel)channel);
        LOG.assertTrue(isSet);
        this.isEventLoopGroupOwner = isOwnEventLoopGroup;
    }

    public void channelActive(@NotNull ChannelHandlerContext context) throws Exception {
        this.clientChannels.add(context.channel());
        super.channelActive(context);
    }

    public void channelInactive(@NotNull ChannelHandlerContext context) throws Exception {
        this.clientChannels.remove(context.channel());
        super.channelInactive(context);
    }

    public void close() {
        this.close(this.isEventLoopGroupOwner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean shutdownEventLoopGroup) {
        ServerChannel serverChannel = this.serverChannel.get();
        if (serverChannel == null) {
            LOG.assertTrue(this.clientChannels.isEmpty());
            return;
        }
        if (!this.serverChannel.compareAndSet(serverChannel, null)) {
            return;
        }
        EventLoopGroup eventLoopGroup = shutdownEventLoopGroup ? serverChannel.eventLoop().parent() : null;
        try {
            long start = System.currentTimeMillis();
            Object[] clientChannels = this.clientChannels.toArray(new Channel[0]);
            this.clientChannels.clear();
            final CountDownLatch countDown = new CountDownLatch(clientChannels.length + 1);
            GenericFutureListener<ChannelFuture> listener2 = new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(@NotNull ChannelFuture future2) throws Exception {
                    try {
                        Throwable cause = future2.cause();
                        if (cause != null) {
                            LOG.warn(cause);
                        }
                    }
                    finally {
                        countDown.countDown();
                    }
                }
            };
            serverChannel.close().addListener((GenericFutureListener)listener2);
            for (Channel channel : clientChannels) {
                channel.close().addListener((GenericFutureListener)listener2);
            }
            try {
                countDown.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Cannot close all channels for 10 seconds, channels: " + Arrays.toString(clientChannels));
            }
            long duration = System.currentTimeMillis() - start;
            if (duration > 1000L) {
                LOG.info("Close all channels took " + duration + " ms: " + duration / 60000L + " min " + duration % 60000L / 1000L + "sec");
            }
        }
        finally {
            if (eventLoopGroup != null) {
                eventLoopGroup.shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
            }
        }
    }
}

