/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

public final class NettyUtil {
    public static final int MAX_CONTENT_LENGTH = 0x6400000;
    public static final int DEFAULT_CONNECT_ATTEMPT_COUNT = 20;
    public static final int MIN_START_TIME = 100;

    public static void logAndClose(@NotNull Throwable error, @NotNull Logger log, @NotNull Channel channel) {
        try {
            if (error instanceof ConnectException) {
                log.debug(error);
            } else {
                NettyUtil.log(error, log);
            }
        }
        finally {
            log.info("Channel will be closed due to error");
            channel.close();
        }
    }

    public static void log(@NotNull Throwable throwable, @NotNull Logger log) {
        if (NettyUtil.isAsWarning(throwable)) {
            log.warn(throwable);
        } else {
            log.error(throwable);
        }
    }

    private static boolean isAsWarning(@NotNull Throwable throwable) {
        String message2 = throwable.getMessage();
        if (message2 == null) {
            return false;
        }
        return throwable instanceof IOException && message2.equals("An existing connection was forcibly closed by the remote host") || throwable instanceof ChannelException && message2.startsWith("Failed to bind to: ") || throwable instanceof BindException || message2.startsWith("Connection reset") || message2.equals("Operation timed out") || message2.equals("Connection timed out");
    }

    public static Bootstrap nioClientBootstrap() {
        return NettyUtil.nioClientBootstrap((EventLoopGroup)new NioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE));
    }

    public static Bootstrap nioClientBootstrap(@NotNull EventLoopGroup eventLoopGroup) {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group(eventLoopGroup)).channel(NioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        return bootstrap;
    }

    public static void addHttpServerCodec(@NotNull ChannelPipeline pipeline) {
        pipeline.addLast("httpRequestEncoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("httpRequestDecoder", (ChannelHandler)new HttpRequestDecoder(16384, 16384, 8192));
        pipeline.addLast("httpObjectAggregator", (ChannelHandler)new HttpObjectAggregator(0x6400000));
        if (pipeline.get(ChunkedWriteHandler.class) == null) {
            pipeline.addLast("chunkedWriteHandler", (ChannelHandler)new ChunkedWriteHandler());
        }
        pipeline.addLast("corsHandler", (ChannelHandler)new CorsHandlerDoNotUseOwnLogger(CorsConfigBuilder.forAnyOrigin().shortCircuit().allowCredentials().allowNullOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.PATCH}).allowedRequestHeaders(new String[]{"origin", "accept", "authorization", "content-type", "x-ijt"}).build()));
    }

    public static void awaitQuiescenceOfGlobalEventExecutor(long timeout, @NotNull TimeUnit unit) {
        try {
            GlobalEventExecutor executor = GlobalEventExecutor.INSTANCE;
            executor.awaitInactivity(timeout, unit);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static final class CorsHandlerDoNotUseOwnLogger
    extends CorsHandler {
        public CorsHandlerDoNotUseOwnLogger(@NotNull CorsConfig config) {
            super(config);
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            context.fireExceptionCaught(cause);
        }
    }
}

