/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.jsonRpc.ExceptionHandler;

public abstract class Client
extends UserDataHolderBase {
    protected final Channel channel;
    final ConcurrentIntObjectMap<AsyncPromise<Object>> messageCallbackMap = ContainerUtil.createConcurrentIntObjectMap();

    protected Client(@NotNull Channel channel) {
        this.channel = channel;
    }

    @NotNull
    public final EventLoop getEventLoop() {
        return this.channel.eventLoop();
    }

    @NotNull
    public final ByteBufAllocator getByteBufAllocator() {
        return this.channel.alloc();
    }

    @NotNull
    protected abstract ChannelFuture send(@NotNull ByteBuf var1);

    public abstract void sendHeartbeat();

    @Nullable
    final <T> AsyncPromise<T> send(int messageId, @NotNull ByteBuf message2) {
        ChannelFuture channelFuture = this.send(message2);
        if (messageId == -1) {
            return null;
        }
        ChannelFutureAwarePromise promise2 = new ChannelFutureAwarePromise(messageId, this.messageCallbackMap);
        channelFuture.addListener(promise2);
        this.messageCallbackMap.put(messageId, promise2);
        return promise2;
    }

    final void rejectAsyncResults(@NotNull ExceptionHandler exceptionHandler) {
        if (!this.messageCallbackMap.isEmpty()) {
            Enumeration elements = this.messageCallbackMap.elements();
            while (elements.hasMoreElements()) {
                try {
                    ((AsyncPromise)elements.nextElement()).setError("rejected");
                }
                catch (Throwable e) {
                    exceptionHandler.exceptionCaught(e);
                }
            }
        }
    }

    private static final class ChannelFutureAwarePromise<T>
    extends AsyncPromise<T>
    implements ChannelFutureListener {
        private final int messageId;
        private final ConcurrentIntObjectMap<?> messageCallbackMap;

        public ChannelFutureAwarePromise(int messageId, ConcurrentIntObjectMap<?> messageCallbackMap) {
            this.messageId = messageId;
            this.messageCallbackMap = messageCallbackMap;
        }

        public boolean setError(@NotNull Throwable error) {
            boolean result2 = super.setError(error);
            this.messageCallbackMap.remove(this.messageId);
            return result2;
        }

        public void operationComplete(ChannelFuture future2) throws Exception {
            if (!future2.isSuccess()) {
                Throwable cause = future2.cause();
                if (cause == null) {
                    this.setError("No success");
                } else {
                    this.setError(cause);
                }
            }
        }
    }
}

