/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.util.io.NettyKt;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.WebSocketClient;
import org.jetbrains.io.webSocket.WebSocketProtocolHandler;

@ChannelHandler.Sharable
final class MessageChannelHandler
extends WebSocketProtocolHandler {
    private final ClientManager clientManager;
    private final MessageServer messageServer;

    MessageChannelHandler(@NotNull ClientManager clientManager, @NotNull MessageServer messageServer) {
        this.clientManager = clientManager;
        this.messageServer = messageServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeFrameReceived(@NotNull Channel channel, @NotNull CloseWebSocketFrame message2) {
        WebSocketClient client = (WebSocketClient)((Object)channel.attr(ClientManagerKt.getCLIENT()).get());
        if (client == null) {
            super.closeFrameReceived(channel, message2);
        } else {
            try {
                this.clientManager.disconnectClient(channel, client, false);
            }
            finally {
                client.disconnect(message2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void textFrameReceived(@NotNull Channel channel, @NotNull TextWebSocketFrame message2) {
        String chars;
        WebSocketClient client = (WebSocketClient)((Object)channel.attr(ClientManagerKt.getCLIENT()).get());
        try {
            chars = NettyKt.readUtf8(message2.content());
        }
        catch (Throwable e) {
            try {
                message2.release();
            }
            finally {
                this.clientManager.getExceptionHandler().exceptionCaught(e);
            }
            return;
        }
        try {
            this.messageServer.messageReceived(client, chars);
        }
        catch (Throwable e) {
            this.clientManager.getExceptionHandler().exceptionCaught(e);
        }
    }

    public void channelInactive(ChannelHandlerContext context) throws Exception {
        Client client = (Client)((Object)context.channel().attr(ClientManagerKt.getCLIENT()).get());
        if (client != null) {
            this.clientManager.disconnectClient(context.channel(), client, false);
        }
    }

    @Override
    public void exceptionCaught(@NotNull ChannelHandlerContext context, @NotNull Throwable cause) {
        try {
            this.clientManager.getExceptionHandler().exceptionCaught(cause);
        }
        finally {
            super.exceptionCaught(context, cause);
        }
    }
}

