/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.webSocket;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Disposer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.jsonRpc.MessageServer;
import org.jetbrains.io.webSocket.MessageChannelHandler;
import org.jetbrains.io.webSocket.WebSocketClient;

public abstract class WebSocketHandshakeHandler
extends HttpRequestHandler
implements ClientListener,
ExceptionHandler {
    private static final Logger LOG = Logger.getInstance(WebSocketHandshakeHandler.class);
    private final AtomicNotNullLazyValue<ClientManager> clientManager = new AtomicNotNullLazyValue<ClientManager>(){

        @NotNull
        protected ClientManager compute() {
            ClientManager result2 = new ClientManager(WebSocketHandshakeHandler.this, WebSocketHandshakeHandler.this, null);
            Disposable serverDisposable = BuiltInServerManager.getInstance().getServerDisposable();
            assert (serverDisposable != null);
            Disposer.register((Disposable)serverDisposable, (Disposable)result2);
            WebSocketHandshakeHandler.this.serverCreated(result2);
            return result2;
        }
    };

    @Override
    public boolean isSupported(@NotNull FullHttpRequest request) {
        return request.method() == HttpMethod.GET && "WebSocket".equalsIgnoreCase(request.headers().getAsString((CharSequence)HttpHeaderNames.UPGRADE)) && request.uri().length() > 2;
    }

    protected void serverCreated(@NotNull ClientManager server) {
    }

    @Override
    public void exceptionCaught(@NotNull Throwable e) {
        NettyUtil.log(e, LOG);
    }

    @Override
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        this.handleWebSocketRequest(context, request, urlDecoder);
        return true;
    }

    private void handleWebSocketRequest(final @NotNull ChannelHandlerContext context, @NotNull FullHttpRequest request, final @NotNull QueryStringDecoder uriDecoder) {
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory("ws://" + request.headers().getAsString((CharSequence)HttpHeaderNames.HOST) + uriDecoder.path(), null, false, 0x6400000);
        WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)request);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)context.channel());
            return;
        }
        if (!context.channel().isOpen()) {
            return;
        }
        final WebSocketClient client = new WebSocketClient(context.channel(), handshaker);
        context.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
        handshaker.handshake(context.channel(), request).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future2) throws Exception {
                if (future2.isSuccess()) {
                    ClientManager clientManager = (ClientManager)WebSocketHandshakeHandler.this.clientManager.getValue();
                    clientManager.addClient(client);
                    MessageChannelHandler messageChannelHandler = new MessageChannelHandler(clientManager, WebSocketHandshakeHandler.this.getMessageServer());
                    BuiltInServer.replaceDefaultHandler(context, (ChannelHandler)messageChannelHandler);
                    ChannelHandlerContext messageChannelHandlerContext = context.pipeline().context((ChannelHandler)messageChannelHandler);
                    context.pipeline().addBefore(messageChannelHandlerContext.name(), "webSocketFrameAggregator", (ChannelHandler)new WebSocketFrameAggregator(0x6400000));
                    messageChannelHandlerContext.channel().attr(ClientManagerKt.getCLIENT()).set((Object)client);
                    WebSocketHandshakeHandler.this.connected(client, uriDecoder.parameters());
                }
            }
        });
    }

    @NotNull
    protected abstract MessageServer getMessageServer();

    @Override
    public void connected(@NotNull Client client, @Nullable Map<String, List<String>> parameters2) {
    }
}

