/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.config.FilterPattern;
import org.jetbrains.java.generate.psi.PsiAdapter;

public class GenerateToStringUtils {
    private static final Logger log = Logger.getInstance((String)"#GenerateToStringUtils");

    private GenerateToStringUtils() {
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, FilterPattern pattern) {
        return GenerateToStringUtils.filterAvailableFields(clazz, false, pattern);
    }

    @NotNull
    public static PsiField[] filterAvailableFields(PsiClass clazz, boolean includeSuperClass, FilterPattern pattern) {
        PsiField[] fields;
        if (log.isDebugEnabled()) {
            log.debug("Filtering fields using the pattern: " + pattern);
        }
        ArrayList<PsiField> availableFields = new ArrayList<PsiField>();
        for (PsiField field : fields = includeSuperClass ? clazz.getAllFields() : clazz.getFields()) {
            if (!JavaResolveUtil.isAccessible((PsiMember)field, field.getContainingClass(), field.getModifierList(), (PsiElement)clazz, null, null) || pattern.fieldMatches(field)) continue;
            availableFields.add(field);
        }
        return availableFields.toArray(new PsiField[availableFields.size()]);
    }

    @NotNull
    public static PsiMethod[] filterAvailableMethods(PsiClass clazz, @NotNull FilterPattern pattern) {
        PsiMethod[] methods;
        if (log.isDebugEnabled()) {
            log.debug("Filtering methods using the pattern: " + pattern);
        }
        ArrayList<PsiMethod> availableMethods = new ArrayList<PsiMethod>();
        for (PsiMethod method2 : methods = clazz.getAllMethods()) {
            String methodName;
            String fieldName;
            PsiType returnType;
            if (!PsiAdapter.isGetterMethod(method2) || (returnType = method2.getReturnType()) == null || PsiType.VOID.equals((Object)returnType) || !method2.hasModifierProperty("public") || method2.hasModifierProperty("static") || method2.hasModifierProperty("abstract") || clazz.findFieldByName(fieldName = PsiAdapter.getGetterFieldName(method2), false) != null || "toString".equals(methodName = method2.getName()) || "getClass".equals(methodName) || "hashCode".equals(methodName) || pattern.methodMatches(method2)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding the method " + methodName + " as there is not a field for this getter");
            }
            availableMethods.add(method2);
        }
        return availableMethods.toArray(new PsiMethod[availableMethods.size()]);
    }
}

