/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.psi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiAdapter {
    private PsiAdapter() {
    }

    public static boolean isConstantField(PsiField field) {
        PsiModifierList list = field.getModifierList();
        if (list == null) {
            return false;
        }
        if (!list.hasModifierProperty("static")) {
            return false;
        }
        return !StringUtil.hasLowerCaseChar((String)field.getName());
    }

    @Nullable
    public static PsiMethod findMethodByName(PsiClass clazz, String name) {
        PsiMethod[] methods = clazz.getMethods();
        for (int i2 = methods.length - 1; i2 >= 0; --i2) {
            PsiMethod method2 = methods[i2];
            if (!name.equals(method2.getName())) continue;
            return method2;
        }
        return null;
    }

    public static boolean isPrimitiveArrayType(PsiType type2) {
        return type2 instanceof PsiArrayType && PsiAdapter.isPrimitiveType(((PsiArrayType)type2).getComponentType());
    }

    public static boolean isObjectArrayType(PsiType type2) {
        return type2 instanceof PsiArrayType && !PsiAdapter.isPrimitiveType(((PsiArrayType)type2).getComponentType());
    }

    public static boolean isStringArrayType(PsiType type2) {
        if (PsiAdapter.isPrimitiveType(type2)) {
            return false;
        }
        return type2.getCanonicalText().indexOf("String[]") > 0;
    }

    public static boolean isCollectionType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.util.Collection");
    }

    public static boolean isMapType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.util.Map");
    }

    public static boolean isSetType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.util.Set");
    }

    public static boolean isListType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.util.List");
    }

    public static boolean isStringType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.lang.String");
    }

    public static boolean isObjectType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.lang.Object");
    }

    public static boolean isDateType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.util.Date");
    }

    public static boolean isCalendarType(PsiElementFactory factory, PsiType type2) {
        return PsiAdapter.isTypeOf(factory, type2, "java.util.Calendar");
    }

    public static boolean isBooleanType(PsiElementFactory factory, PsiType type2) {
        if (PsiAdapter.isPrimitiveType(type2)) {
            String s = type2.getCanonicalText();
            return "boolean".equals(s);
        }
        return PsiAdapter.isTypeOf(factory, type2, "java.lang.Boolean");
    }

    public static boolean isNumericType(PsiElementFactory factory, PsiType type2) {
        if (PsiAdapter.isPrimitiveType(type2)) {
            String s = type2.getCanonicalText();
            return "byte".equals(s) || "double".equals(s) || "float".equals(s) || "int".equals(s) || "long".equals(s) || "short".equals(s);
        }
        return PsiAdapter.isTypeOf(factory, type2, "java.lang.Number");
    }

    public static boolean hasImportStatement(PsiJavaFile javaFile, String importStatement) {
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        if (importStatement.endsWith(".*")) {
            return importList.findOnDemandImportStatement(PsiAdapter.fixImportStatement(importStatement)) != null;
        }
        return importList.findSingleClassImportStatement(importStatement) != null;
    }

    public static void addImportStatement(PsiJavaFile javaFile, String importStatementOnDemand) {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)javaFile.getProject()).getElementFactory();
        PsiImportStatement is = factory.createImportStatementOnDemand(PsiAdapter.fixImportStatement(importStatementOnDemand));
        PsiImportList importList = javaFile.getImportList();
        if (importList != null) {
            importList.add((PsiElement)is);
        }
        JavaCodeStyleManager.getInstance((Project)javaFile.getProject()).optimizeImports((PsiFile)javaFile);
    }

    private static String fixImportStatement(String importStatementOnDemand) {
        if (importStatementOnDemand.endsWith(".*")) {
            return importStatementOnDemand.substring(0, importStatementOnDemand.length() - 2);
        }
        boolean hasClassname = StringUtil.hasUpperCaseChar((String)importStatementOnDemand);
        if (hasClassname) {
            int pos = importStatementOnDemand.lastIndexOf(".");
            return importStatementOnDemand.substring(0, pos);
        }
        return importStatementOnDemand;
    }

    @Nullable
    public static String getTypeQualifiedClassName(PsiType type2) {
        if (PsiAdapter.isPrimitiveType(type2)) {
            return null;
        }
        String name = type2.getCanonicalText();
        if (name.endsWith("[]")) {
            return name.substring(0, name.length() - 2);
        }
        return name;
    }

    @Nullable
    public static String getTypeClassName(PsiType type2) {
        String name = PsiAdapter.getTypeQualifiedClassName(type2);
        if (name == null) {
            return null;
        }
        return StringUtil.getShortName((String)name);
    }

    @Nullable
    public static PsiMethod findPublicStaticVoidMainMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method2 : methods = clazz.findMethodsByName("main", false)) {
            PsiParameter[] parameters2;
            PsiType returnType;
            if (!method2.hasModifierProperty("public") || !method2.hasModifierProperty("static") || !PsiType.VOID.equals((Object)(returnType = method2.getReturnType())) || (parameters2 = method2.getParameterList().getParameters()).length != 1 || !PsiAdapter.isStringArrayType(parameters2[0].getType())) continue;
            return method2;
        }
        return null;
    }

    @Nullable
    public static PsiComment addOrReplaceJavadoc(PsiMethod method2, String javadoc, boolean replace) {
        Project project2 = method2.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiComment comment = factory.createCommentFromText(javadoc, null);
        PsiDocComment doc = method2.getDocComment();
        if (doc != null) {
            if (replace) {
                doc.replace((PsiElement)comment);
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
                codeStyleManager.reformat((PsiElement)method2);
                return comment;
            }
            return null;
        }
        method2.addBefore((PsiElement)comment, method2.getFirstChild());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        codeStyleManager.reformat((PsiElement)method2);
        return comment;
    }

    public static boolean isTypeOfVoid(PsiType type2) {
        return type2 != null && type2.equalsToText("void");
    }

    public static boolean isGetterMethod(PsiMethod method2) {
        if (PsiAdapter.isTypeOfVoid(method2.getReturnType())) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        return parameterList.getParametersCount() == 0;
    }

    @Nullable
    public static String getGetterFieldName(PsiMethod method2) {
        if (!PsiAdapter.isGetterMethod(method2)) {
            return null;
        }
        return PropertyUtil.getPropertyNameByGetter((PsiMethod)method2);
    }

    public static boolean isEnumField(PsiField field) {
        PsiType type2 = field.getType();
        if (!(type2 instanceof PsiClassType)) {
            return false;
        }
        PsiClassType classType = (PsiClassType)type2;
        PsiClass aClass = classType.resolve();
        return aClass != null && aClass.isEnum();
    }

    public static boolean isExceptionClass(PsiClass clazz) {
        return InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Throwable");
    }

    @Nullable
    public static PsiMethod findEqualsMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method2 : methods = clazz.findMethodsByName("equals", false)) {
            PsiParameter[] parameters2;
            PsiType returnType;
            if (!method2.hasModifierProperty("public") || method2.hasModifierProperty("static") || !PsiType.BOOLEAN.equals((Object)(returnType = method2.getReturnType())) || (parameters2 = method2.getParameterList().getParameters()).length != 1 || !parameters2[0].getType().getCanonicalText().equals("java.lang.Object")) continue;
            return method2;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findHashCodeMethod(PsiClass clazz) {
        PsiMethod[] methods;
        for (PsiMethod method2 : methods = clazz.findMethodsByName("hashCode", false)) {
            PsiParameterList parameters2;
            PsiType returnType;
            if (!method2.hasModifierProperty("public") || method2.hasModifierProperty("static") || !PsiType.INT.equals((Object)(returnType = method2.getReturnType())) || (parameters2 = method2.getParameterList()).getParametersCount() != 0) continue;
            return method2;
        }
        return null;
    }

    protected static boolean isTypeOf(PsiElementFactory factory, PsiType type2, String typeFQClassName) {
        if (PsiAdapter.isTypeOfVoid(type2)) {
            return false;
        }
        if (PsiAdapter.isPrimitiveType(type2)) {
            return false;
        }
        GlobalSearchScope scope = type2.getResolveScope();
        if (scope == null) {
            return false;
        }
        PsiClassType typeTarget = factory.createTypeByFQClassName(typeFQClassName, scope);
        return typeTarget.isAssignableFrom(type2);
    }

    public static String[] getImplementsClassnames(PsiClass clazz) {
        PsiClass[] interfaces = clazz.getInterfaces();
        if (interfaces == null || interfaces.length == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        String[] names = new String[interfaces.length];
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            PsiClass anInterface = interfaces[i2];
            names[i2] = anInterface.getName();
        }
        return names;
    }

    public static boolean isPrimitiveType(PsiType type2) {
        return type2 instanceof PsiPrimitiveType;
    }

    public static int getJavaVersion(@NotNull PsiElement element) {
        JavaSdkVersion sdkVersion = JavaVersionService.getInstance().getJavaSdkVersion(element);
        if (sdkVersion == null) {
            sdkVersion = JavaSdkVersion.fromLanguageLevel((LanguageLevel)PsiUtil.getLanguageLevel((PsiElement)element));
        }
        int version = 0;
        switch (sdkVersion) {
            case JDK_1_0: 
            case JDK_1_1: {
                version = 1;
                break;
            }
            case JDK_1_2: {
                version = 2;
                break;
            }
            case JDK_1_3: {
                version = 3;
                break;
            }
            case JDK_1_4: {
                version = 4;
                break;
            }
            case JDK_1_5: {
                version = 5;
                break;
            }
            case JDK_1_6: {
                version = 6;
                break;
            }
            case JDK_1_7: {
                version = 7;
                break;
            }
            case JDK_1_8: {
                version = 8;
                break;
            }
            case JDK_1_9: {
                version = 9;
            }
        }
        return version;
    }

    public static boolean isNestedArray(PsiType aType) {
        if (!(aType instanceof PsiArrayType)) {
            return false;
        }
        PsiType componentType = ((PsiArrayType)aType).getComponentType();
        return componentType instanceof PsiArrayType;
    }
}

