/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.generate.view;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiType;
import com.intellij.util.LocalTimeCounter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.generate.element.ClassElement;
import org.jetbrains.java.generate.element.FieldElement;
import org.jetbrains.java.generate.element.GenerationHelper;
import org.jetbrains.java.generate.template.TemplateResource;
import org.jetbrains.java.generate.template.TemplatesManager;

public class GenerateTemplateConfigurable
implements UnnamedConfigurable {
    private final TemplateResource template;
    private final Editor myEditor;
    private final List<String> availableImplicits = new ArrayList<String>();
    private String myHint;

    public GenerateTemplateConfigurable(TemplateResource template, Map<String, PsiType> contextMap, Project project2) {
        this(template, contextMap, project2, true);
    }

    public GenerateTemplateConfigurable(TemplateResource template, Map<String, PsiType> contextMap, Project project2, boolean multipleFields) {
        this.template = template;
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = factory.createDocument((CharSequence)template.getTemplate());
        FileType ftl = FileTypeManager.getInstance().findFileTypeByName("VTL");
        if (project2 != null && ftl != null) {
            Document document;
            PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText(template.getFileName(), ftl, (CharSequence)template.getTemplate(), LocalTimeCounter.currentTime(), true);
            if (!template.isDefault()) {
                LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
                map2.put("java_version", PsiType.INT);
                map2.put("class", TemplatesManager.createElementType(project2, ClassElement.class));
                if (multipleFields) {
                    map2.put("fields", TemplatesManager.createFieldListElementType(project2));
                } else {
                    map2.put("field", TemplatesManager.createElementType(project2, FieldElement.class));
                }
                map2.put("helper", TemplatesManager.createElementType(project2, GenerationHelper.class));
                map2.put("settings", PsiType.NULL);
                map2.putAll(contextMap);
                this.availableImplicits.addAll(((HashMap)map2).keySet());
                file2.getViewProvider().putUserData(TemplatesManager.TEMPLATE_IMPLICITS, map2);
            }
            if ((document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2)) != null) {
                doc = document;
            }
        }
        this.myEditor = factory.createEditor(doc, project2, (FileType)(ftl != null ? ftl : FileTypes.PLAIN_TEXT), template.isDefault());
    }

    public void setHint(String hint) {
        this.myHint = hint;
    }

    public JComponent createComponent() {
        JComponent component = this.myEditor.getComponent();
        if (this.availableImplicits.isEmpty() && this.myHint == null) {
            return component;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)component, "Center");
        JLabel label = new JLabel("<html>" + (!this.availableImplicits.isEmpty() ? "Available implicit variables:<br/>" + StringUtil.join(this.availableImplicits, (String)", ") + "<br/>" : "") + (this.myHint != null ? this.myHint : "") + "</html>");
        panel2.add((Component)label, "South");
        return panel2;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.myEditor.getDocument().getText(), (String)this.template.getTemplate());
    }

    public void apply() throws ConfigurationException {
        this.template.setTemplate(this.myEditor.getDocument().getText());
    }

    public void reset() {
        new WriteCommandAction(null, new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                GenerateTemplateConfigurable.this.myEditor.getDocument().setText((CharSequence)GenerateTemplateConfigurable.this.template.getTemplate());
            }
        }.execute();
    }

    public void disposeUIResources() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

